/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v2_0;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.ows11.KeywordsType;
import net.opengis.ows11.LanguageStringType;
import net.opengis.ows11.WGS84BoundingBoxType;
import net.opengis.wfs20.AbstractType;
import net.opengis.wfs20.FeatureTypeType;
import net.opengis.wfs20.OutputFormatListType;
import net.opengis.wfs20.TitleType;
import org.eclipse.emf.common.util.EList;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class FeatureTypeInfoImpl
implements FeatureTypeInfo {
    private final FeatureTypeType eType;
    private final WFSConfig config;

    public FeatureTypeInfoImpl(FeatureTypeType eType, WFSConfig config) {
        this.eType = eType;
        this.config = config;
    }

    @Override
    public String getTitle() {
        return this.eType.getTitle() == null || this.eType.getTitle().isEmpty() ? null : String.valueOf(((TitleType)this.eType.getTitle().get(0)).getValue());
    }

    @Override
    public Set<String> getKeywords() {
        Set<String> ret;
        EList keywords = this.eType.getKeywords();
        if (keywords == null) {
            ret = Collections.emptySet();
        } else {
            ret = new HashSet();
            for (KeywordsType k : keywords) {
                EList keyword = k.getKeyword();
                for (LanguageStringType ls : keyword) {
                    ret.add(ls.getValue());
                }
            }
            ret.remove(null);
        }
        return ret;
    }

    public String getDescription() {
        return this.eType.getAbstract() == null || this.eType.getAbstract().isEmpty() ? null : ((AbstractType)this.eType.getAbstract().get(0)).getValue();
    }

    public String getName() {
        return this.config.localTypeName(this.eType.getName());
    }

    public QName getQName() {
        return this.eType.getName();
    }

    public URI getSchema() {
        String namespaceURI = this.eType.getName().getNamespaceURI();
        try {
            return "".equals(namespaceURI) ? null : new URI(namespaceURI);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope nativeBounds;
        ReferencedEnvelope wgs84Bounds = this.getWGS84BoundingBox();
        CoordinateReferenceSystem crs = this.getCRS();
        if (null == crs) {
            return wgs84Bounds;
        }
        try {
            nativeBounds = wgs84Bounds.transform(crs, true);
        }
        catch (FactoryException | TransformException e) {
            Loggers.MODULE.log(Level.WARNING, "Can't transform bounds of " + this.getName() + " to " + this.getDefaultSRS(), e);
            nativeBounds = new ReferencedEnvelope(crs);
        }
        return nativeBounds;
    }

    @Override
    public String getDefaultSRS() {
        return this.eType.getDefaultCRS();
    }

    public CoordinateReferenceSystem getCRS() {
        CoordinateReferenceSystem crs = null;
        String defaultSRS = this.eType.getDefaultCRS();
        if (null != defaultSRS) {
            try {
                crs = CRS.decode((String)defaultSRS);
            }
            catch (Exception e) {
                Logger.getGlobal().log(Level.INFO, "", e);
            }
        }
        return crs;
    }

    @Override
    public ReferencedEnvelope getWGS84BoundingBox() {
        EList bboxList = this.eType.getWGS84BoundingBox();
        if (bboxList == null || bboxList.isEmpty()) {
            return null;
        }
        WGS84BoundingBoxType bboxType = (WGS84BoundingBoxType)bboxList.get(0);
        List lowerCorner = bboxType.getLowerCorner();
        List upperCorner = bboxType.getUpperCorner();
        double minLon = (Double)lowerCorner.get(0);
        double minLat = (Double)lowerCorner.get(1);
        double maxLon = (Double)upperCorner.get(0);
        double maxLat = (Double)upperCorner.get(1);
        ReferencedEnvelope latLonBounds = new ReferencedEnvelope(minLon, maxLon, minLat, maxLat, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        return latLonBounds;
    }

    @Override
    public List<String> getOtherSRS() {
        return this.eType.getOtherCRS();
    }

    @Override
    public Set<String> getOutputFormats() {
        OutputFormatListType outputFormats = this.eType.getOutputFormats();
        if (null == outputFormats) {
            return Collections.emptySet();
        }
        EList ftypeDeclaredFormats = outputFormats.getFormat();
        if (null == ftypeDeclaredFormats || ftypeDeclaredFormats.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>((Collection<String>)ftypeDeclaredFormats);
    }

    @Override
    public String getAbstract() {
        StringBuffer sb = new StringBuffer();
        for (Object a : this.eType.getAbstract()) {
            sb.append(a);
            sb.append(" ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

