/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.util.InternationalString;
import org.geotools.renderer.i18n.ErrorKeys;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.renderer.lite.gridcoverage2d.StyleVisitorCoverageProcessingNodeAdapter;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public abstract class SubchainStyleVisitorCoverageProcessingAdapter
extends StyleVisitorCoverageProcessingNodeAdapter {
    private static final Logger LOGGER = Logging.getLogger(RasterSymbolizerHelper.class);
    private CoverageProcessingNode sink;

    public SubchainStyleVisitorCoverageProcessingAdapter(CoverageProcessingNode adaptee) {
        super(adaptee);
    }

    public SubchainStyleVisitorCoverageProcessingAdapter(InternationalString name, InternationalString description) {
        super(name, description);
    }

    public SubchainStyleVisitorCoverageProcessingAdapter(int maxSources, InternationalString name, InternationalString description) {
        super(maxSources, name, description);
    }

    public SubchainStyleVisitorCoverageProcessingAdapter(int maxSources, Hints hints, InternationalString name, InternationalString description) {
        super(maxSources, hints, name, description);
    }

    @Override
    public void dispose(boolean force) {
        this.dispose(this.sink, force);
        super.dispose(force);
    }

    private void dispose(CoverageProcessingNode node, boolean force) {
        if (node == null) {
            return;
        }
        List<CoverageProcessingNode> sources = node.getSources();
        if (sources != null && !sources.isEmpty()) {
            for (CoverageProcessingNode source : sources) {
                this.dispose(source, force);
            }
        }
        node.dispose(force);
    }

    protected void setSink(CoverageProcessingNode sink) {
        GridCoverageRendererUtilities.ensureNotNull(sink, "sink");
        if (this.sink != null) {
            throw new IllegalStateException(ErrorKeys.SINK_ALREADY_SET);
        }
        this.sink = sink;
    }

    @Override
    public GridCoverage execute() {
        if (this.sink != null) {
            return this.sink.getOutput();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Sink for this chain is null, It was probably not set.");
        }
        return null;
    }
}

