/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Halo;
import org.geotools.api.style.ImageOutline;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.OverlapBehavior;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.UserLayer;
import org.geotools.filter.ConstantExpression;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.util.logging.Logging;

public class MetaBufferEstimator
extends FilterAttributeExtractor
implements StyleVisitor {
    protected static final Logger LOGGER = Logging.getLogger(MetaBufferEstimator.class);
    protected FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
    protected boolean estimateAccurate = true;
    protected int buffer = 0;
    Feature sample;

    public MetaBufferEstimator() {
    }

    public MetaBufferEstimator(Feature sample) {
        this.sample = sample;
    }

    public void reset() {
        this.estimateAccurate = true;
        this.buffer = 0;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public boolean isEstimateAccurate() {
        return this.estimateAccurate;
    }

    public void visit(Style style) {
        style.featureTypeStyles().forEach(ft -> ft.accept((StyleVisitor)this));
    }

    public void visit(Rule rule) {
        Filter filter = rule.getFilter();
        if (filter != null) {
            filter.accept((FilterVisitor)this, null);
        }
        rule.symbolizers().forEach(s -> s.accept((StyleVisitor)this));
    }

    public void visit(FeatureTypeStyle fts) {
        for (Rule rule : fts.rules()) {
            rule.accept((StyleVisitor)this);
        }
    }

    public void visit(Fill fill) {
    }

    public void visit(Stroke stroke) {
        try {
            Expression width = stroke.getWidth();
            if (!this.isNull(width)) {
                this.evaluateWidth(width);
            }
            if (stroke.getGraphicStroke() != null) {
                stroke.getGraphicStroke().accept((StyleVisitor)this);
            }
        }
        catch (ClassCastException e) {
            this.estimateAccurate = false;
            LOGGER.info("Could not parse stroke width, it's a literal but not a Number...");
        }
    }

    protected boolean isNull(Expression exp) {
        return exp == null || exp instanceof NilExpression || exp instanceof ConstantExpression && ((ConstantExpression)exp).getValue() == null;
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        }
        if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        }
        if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        }
        if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        }
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        }
    }

    public void visit(RasterSymbolizer rs) {
        if (rs.getGeometryPropertyName() != null) {
            this.attributeNames.add(rs.getGeometryPropertyName());
        }
        if (rs.getImageOutline() != null) {
            rs.getImageOutline().accept((StyleVisitor)this);
        }
        if (rs.getOpacity() != null) {
            rs.getOpacity().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(PointSymbolizer ps) {
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (poly.getStroke() != null) {
            poly.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(TextSymbolizer text) {
        Graphic graphic;
        if (text.fonts() != null && !text.fonts().isEmpty()) {
            for (Font font : text.fonts()) {
                int textSize = this.getPositiveValue(font.getSize());
                int delta = -1;
                if (text.getLabelPlacement() instanceof PointPlacement) {
                    AnchorPoint ap;
                    PointPlacement pp = (PointPlacement)text.getLabelPlacement();
                    Displacement pd = pp.getDisplacement();
                    if (pd != null) {
                        int dx = this.getPositiveValue(pd.getDisplacementX());
                        int dy = this.getPositiveValue(pd.getDisplacementY());
                        delta = Math.max(dx, dy);
                    }
                    if ((ap = pp.getAnchorPoint()) != null) {
                        double ax = Math.abs(this.getDouble(ap.getAnchorPointX()) - 0.5);
                        double ay = Math.abs(this.getDouble(ap.getAnchorPointY()) - 0.5);
                        int anchorDelta = (int)Math.ceil(Math.max(ax, ay) * (double)textSize);
                        delta = delta > 0 ? (delta += anchorDelta) : anchorDelta;
                    }
                }
                int total = -1;
                if (delta > 0) {
                    total = textSize > 0 ? delta + textSize : delta;
                } else if (textSize > 0) {
                    total = textSize;
                }
                this.buffer = Math.max(this.buffer, total);
            }
        }
        if ((graphic = text.getGraphic()) != null) {
            graphic.accept((StyleVisitor)this);
        }
    }

    public void visit(Graphic gr) {
        try {
            Expression grSize = gr.getSize();
            int imageSize = -1;
            boolean isSizeNull = this.isNull(grSize);
            boolean isSizeConstant = false;
            if (!isSizeNull) {
                isSizeConstant = this.isConstant(grSize);
                if (isSizeConstant) {
                    imageSize = (int)Math.ceil((Double)grSize.evaluate(null, Double.class));
                } else {
                    this.estimateAccurate = false;
                    return;
                }
            }
            for (GraphicalSymbol gs : gr.graphicalSymbols()) {
                if (gs instanceof ExternalGraphic) {
                    ExternalGraphic eg = (ExternalGraphic)gs;
                    Icon icon = null;
                    if (eg.getInlineContent() != null) {
                        icon = eg.getInlineContent();
                    } else {
                        String location = eg.getLocation().toExternalForm();
                        Expression expanded = ExpressionExtractor.extractCqlExpressions(location);
                        if (!(expanded instanceof Literal)) {
                            this.estimateAccurate = false;
                            return;
                        }
                        Iterator<ExternalGraphicFactory> it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
                        while (it.hasNext() && icon == null) {
                            try {
                                ExternalGraphicFactory factory = it.next();
                                icon = factory.getIcon(null, expanded, eg.getFormat(), imageSize);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.FINE, "Error occurred evaluating external graphic", e);
                            }
                        }
                    }
                    if (icon != null) {
                        int size = Math.max(icon.getIconHeight(), icon.getIconWidth());
                        if (size > this.buffer) {
                            this.buffer = size;
                        }
                        return;
                    }
                } else if (gs instanceof Mark) {
                    Mark mark = (Mark)gs;
                    int markSize = isSizeConstant ? imageSize : 16;
                    if (mark.getStroke() != null) {
                        int strokeWidth = this.getPositiveValue(mark.getStroke().getWidth());
                        if (strokeWidth < 0) {
                            this.estimateAccurate = false;
                        } else {
                            markSize += strokeWidth;
                        }
                    }
                    if (markSize > this.buffer) {
                        this.buffer = markSize;
                    }
                    return;
                }
                this.estimateAccurate = false;
            }
        }
        catch (ClassCastException e) {
            this.estimateAccurate = false;
            LOGGER.info("Could not parse graphic size, it's a literal but not a Number...");
        }
        catch (Exception e) {
            this.estimateAccurate = false;
            LOGGER.log(Level.INFO, "Error occured during the graphic size estimation, meta buffer estimate cannot be performed", e);
        }
    }

    protected void evaluateWidth(Expression width) {
        int value = this.getPositiveValue(width);
        if (value < 0) {
            this.estimateAccurate = false;
        } else if (value > this.buffer) {
            this.buffer = value;
        }
    }

    protected int getPositiveValue(Expression ex) {
        double value = this.getDouble(ex);
        if (value == -1.0) {
            return -1;
        }
        return (int)Math.ceil(value);
    }

    protected double getDouble(Expression ex) {
        if (this.isConstant(ex) || this.sample != null) {
            Double result = (Double)ex.evaluate((Object)this.sample, Double.class);
            if (result != null) {
                return result;
            }
            return -1.0;
        }
        return -1.0;
    }

    protected boolean isConstant(Expression ex) {
        if (ex instanceof Literal) {
            return true;
        }
        if (ex instanceof PropertyName) {
            return false;
        }
        this.attributeExtractor.clear();
        ex.accept((ExpressionVisitor)this.attributeExtractor, null);
        return this.attributeExtractor.isConstantExpression();
    }

    public void visit(Mark mark) {
    }

    public void visit(ExternalGraphic exgr) {
    }

    public void visit(PointPlacement pp) {
    }

    public void visit(AnchorPoint ap) {
    }

    public void visit(Displacement dis) {
    }

    public void visit(LinePlacement lp) {
    }

    public void visit(Halo halo) {
    }

    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers;
        for (StyledLayer layer : layers = sld.getStyledLayers()) {
            if (layer instanceof NamedLayer) {
                ((NamedLayer)layer).accept((StyleVisitor)this);
                continue;
            }
            if (!(layer instanceof UserLayer)) continue;
            ((UserLayer)layer).accept((StyleVisitor)this);
        }
    }

    public void visit(NamedLayer layer) {
        Style[] styles;
        for (Style style : styles = layer.getStyles()) {
            style.accept((StyleVisitor)this);
        }
    }

    public void visit(UserLayer layer) {
        Style[] styles;
        for (Style style : styles = layer.getUserStyles()) {
            style.accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
        ftc.accept((StyleVisitor)this);
    }

    public void visit(ColorMap map) {
    }

    public void visit(ColorMapEntry entry) {
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
    }

    public void visit(ImageOutline outline) {
        outline.accept((StyleVisitor)this);
    }

    public void visit(ChannelSelection cs) {
    }

    public void visit(OverlapBehavior ob) {
    }

    public void visit(SelectedChannelType sct) {
    }

    public void visit(ShadedRelief sr) {
    }
}

