/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.api.referencing.operation.Projection;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.referencing.factory.epsg.DirectEpsgFactory;
import org.geotools.referencing.factory.epsg.TableInfo;
import org.geotools.util.logging.Logging;

public final class AuthorityCodes
extends AbstractSet<String>
implements Serializable {
    private static final long serialVersionUID = 7105664579449680562L;
    private final DirectEpsgFactory factory;
    public final Class<?> type;
    private final boolean isProjection;
    private transient java.util.Map<String, String> asMap;
    final String sqlAll;
    private final String sqlSingle;
    private transient PreparedStatement queryAll;
    private transient PreparedStatement querySingle;
    private int size = -1;

    public AuthorityCodes(TableInfo table, Class<?> type, DirectEpsgFactory factory) {
        this.factory = factory;
        StringBuilder buffer = new StringBuilder("SELECT ");
        buffer.append(table.codeColumn);
        if (table.nameColumn != null) {
            buffer.append(", ").append(table.nameColumn);
        }
        buffer.append(" FROM ").append(table.table);
        boolean hasWhere = false;
        Class<?> tableType = table.type;
        if (table.typeColumn != null) {
            for (int i = 0; i < table.subTypes.length; ++i) {
                Class<?> candidate = table.subTypes[i];
                if (!candidate.isAssignableFrom(type)) continue;
                buffer.append(" WHERE (").append(table.typeColumn).append(" LIKE '").append(table.typeNames[i]).append("%'");
                hasWhere = true;
                tableType = candidate;
                break;
            }
            if (hasWhere) {
                buffer.append(')');
            }
        }
        this.type = tableType;
        this.isProjection = Projection.class.isAssignableFrom(tableType);
        int length = buffer.length();
        buffer.append(" ORDER BY ").append(table.codeColumn);
        this.sqlAll = factory.adaptSQL(buffer.toString());
        buffer.setLength(length);
        buffer.append(hasWhere ? " AND " : " WHERE ").append(table.codeColumn).append(" = ?");
        this.sqlSingle = factory.adaptSQL(buffer.toString());
    }

    protected PreparedStatement validateStatement(PreparedStatement stmt, String sql) throws SQLException {
        Connection conn = null;
        if (stmt != null) {
            try {
                conn = stmt.getConnection();
            }
            catch (SQLException sqle) {
                stmt = null;
            }
        }
        if (conn != null && !this.factory.isConnectionValid(conn)) {
            stmt = null;
        }
        if (stmt == null) {
            stmt = this.factory.getConnection().prepareStatement(sql);
        }
        return stmt;
    }

    private ResultSet getAll() throws SQLException {
        assert (Thread.holdsLock(this));
        this.queryAll = this.validateStatement(this.queryAll, this.sqlAll);
        try {
            return this.queryAll.executeQuery();
        }
        catch (SQLException ignore) {
            this.queryAll.close();
            this.queryAll = null;
            AuthorityCodes.recoverableException("getAll", ignore);
            this.queryAll = this.validateStatement(this.queryAll, this.sqlAll);
            return this.queryAll.executeQuery();
        }
    }

    private ResultSet getSingle(Object code) throws SQLException {
        assert (Thread.holdsLock(this));
        this.querySingle = this.validateStatement(this.querySingle, this.sqlSingle);
        this.querySingle.setString(1, code.toString());
        return this.querySingle.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAcceptable(ResultSet results) throws SQLException {
        if (!this.isProjection) {
            return true;
        }
        String code = results.getString(1);
        DirectEpsgFactory directEpsgFactory = this.factory;
        synchronized (directEpsgFactory) {
            return this.factory.isProjection(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAcceptable(String code) throws SQLException {
        if (!this.isProjection) {
            return true;
        }
        DirectEpsgFactory directEpsgFactory = this.factory;
        synchronized (directEpsgFactory) {
            return this.factory.isProjection(code);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.size != -1) {
            return this.size == 0;
        }
        boolean empty = true;
        try (ResultSet results = this.getAll();){
            while (results.next()) {
                if (!this.isAcceptable(results)) continue;
                empty = false;
                break;
            }
        }
        catch (SQLException exception) {
            AuthorityCodes.unexpectedException("isEmpty", exception);
        }
        this.size = empty ? 0 : -2;
        return empty;
    }

    @Override
    public synchronized int size() {
        if (this.size >= 0) {
            return this.size;
        }
        int count = 0;
        try (ResultSet results = this.getAll();){
            while (results.next()) {
                if (!this.isAcceptable(results)) continue;
                ++count;
            }
        }
        catch (SQLException exception) {
            AuthorityCodes.unexpectedException("size", exception);
        }
        this.size = count;
        return count;
    }

    @Override
    public synchronized boolean contains(Object code) {
        boolean exists = false;
        if (code != null) {
            try (ResultSet results = this.getSingle(code);){
                while (results.next()) {
                    if (!this.isAcceptable(results)) continue;
                    exists = true;
                    break;
                }
            }
            catch (SQLException exception) {
                AuthorityCodes.unexpectedException("contains", exception);
            }
        }
        return exists;
    }

    @Override
    public synchronized java.util.Iterator<String> iterator() {
        try {
            Iterator iterator = new Iterator(this.getAll());
            this.queryAll = null;
            return iterator;
        }
        catch (SQLException exception) {
            AuthorityCodes.unexpectedException("iterator", exception);
            Set empty = Collections.emptySet();
            return empty.iterator();
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LinkedHashSet<String>(this);
    }

    protected synchronized void finalize() throws SQLException {
        if (this.querySingle != null) {
            this.querySingle.close();
            this.querySingle = null;
        }
        if (this.queryAll != null) {
            this.queryAll.close();
            this.queryAll = null;
        }
    }

    private static void unexpectedException(String method, SQLException exception) {
        AuthorityCodes.unexpectedException(AuthorityCodes.class, method, exception);
    }

    static void unexpectedException(Class<?> classe, String method, SQLException exception) {
        Logging.unexpectedException(classe, (String)method, (Throwable)exception);
    }

    private static void recoverableException(String method, SQLException exception) {
        LogRecord record = Loggings.format((Level)Level.FINE, (int)43);
        record.setSourceClassName(AuthorityCodes.class.getName());
        record.setSourceMethodName(method);
        record.setThrown(exception);
        Logger logger = Logging.getLogger(AuthorityCodes.class);
        record.setLoggerName(logger.getName());
        logger.log(record);
    }

    final java.util.Map<String, String> asMap() {
        if (this.asMap == null) {
            this.asMap = new Map();
        }
        return this.asMap;
    }

    private final class Map
    extends AbstractMap<String, String> {
        private Map() {
        }

        @Override
        public int size() {
            return AuthorityCodes.this.size();
        }

        @Override
        public boolean isEmpty() {
            return AuthorityCodes.this.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get(Object code) {
            String value = null;
            if (code != null) {
                try {
                    AuthorityCodes authorityCodes = AuthorityCodes.this;
                    synchronized (authorityCodes) {
                        try (ResultSet results = AuthorityCodes.this.getSingle(code);){
                            while (results.next()) {
                                if (!AuthorityCodes.this.isAcceptable(results)) continue;
                                value = results.getString(2);
                                break;
                            }
                        }
                    }
                }
                catch (SQLException exception) {
                    AuthorityCodes.unexpectedException("get", exception);
                }
            }
            return value;
        }

        @Override
        public boolean containsKey(Object key) {
            return AuthorityCodes.this.contains(key);
        }

        @Override
        public Set<String> keySet() {
            return AuthorityCodes.this;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    private final class Iterator
    implements java.util.Iterator<String> {
        private ResultSet results;
        private transient String next;

        Iterator(ResultSet results) throws SQLException {
            assert (Thread.holdsLock(AuthorityCodes.this));
            this.results = results;
            this.toNext();
        }

        private void toNext() throws SQLException {
            while (this.results.next()) {
                this.next = this.results.getString(1);
                if (!AuthorityCodes.this.isAcceptable(this.next)) continue;
                return;
            }
            this.finalize();
        }

        @Override
        public boolean hasNext() {
            return this.results != null;
        }

        @Override
        public String next() {
            if (this.results == null) {
                throw new NoSuchElementException();
            }
            String current = this.next;
            try {
                this.toNext();
            }
            catch (SQLException exception) {
                this.results = null;
                AuthorityCodes.unexpectedException(Iterator.class, "next", exception);
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws SQLException {
            this.next = null;
            if (this.results != null) {
                PreparedStatement owner = (PreparedStatement)this.results.getStatement();
                this.results.close();
                this.results = null;
                AuthorityCodes authorityCodes = AuthorityCodes.this;
                synchronized (authorityCodes) {
                    assert (owner != AuthorityCodes.this.queryAll);
                    if (AuthorityCodes.this.queryAll == null) {
                        AuthorityCodes.this.queryAll = owner;
                    } else {
                        owner.close();
                    }
                }
            }
        }
    }
}

