/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.QueryPhaseRankShardContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class RankBuilder
implements VersionedNamedWriteable,
ToXContentObject {
    public static final ParseField WINDOW_SIZE_FIELD = new ParseField("window_size", new String[0]);
    public static final int DEFAULT_WINDOW_SIZE = 10;
    private final int windowSize;

    public RankBuilder(int windowSize) {
        this.windowSize = windowSize;
    }

    public RankBuilder(StreamInput in) throws IOException {
        this.windowSize = in.readVInt();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.windowSize);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.getWriteableName());
        builder.field(WINDOW_SIZE_FIELD.getPreferredName(), this.windowSize);
        this.doXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int windowSize() {
        return this.windowSize;
    }

    public abstract QueryPhaseRankShardContext buildQueryPhaseShardContext(List<Query> var1, int var2);

    public abstract QueryPhaseRankCoordinatorContext buildQueryPhaseCoordinatorContext(int var1, int var2);

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RankBuilder other = (RankBuilder)obj;
        return Objects.equals(this.windowSize, other.windowSize()) && this.doEquals(other);
    }

    protected abstract boolean doEquals(RankBuilder var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.windowSize, this.doHashCode());
    }

    protected abstract int doHashCode();

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }
}

