/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalWeightedAvg;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.WeightedAvgAggregationBuilder;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.MultiValuesSource;

class WeightedAvgAggregator
extends NumericMetricsAggregator.SingleValue {
    private final MultiValuesSource.NumericMultiValuesSource valuesSources;
    private DoubleArray weights;
    private DoubleArray valueSums;
    private DoubleArray valueCompensations;
    private DoubleArray weightCompensations;
    private final DocValueFormat format;

    WeightedAvgAggregator(String name, MultiValuesSource.NumericMultiValuesSource valuesSources, DocValueFormat format, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSources != null);
        this.valuesSources = valuesSources;
        this.format = format;
        this.weights = this.bigArrays().newDoubleArray(1L, true);
        this.valueSums = this.bigArrays().newDoubleArray(1L, true);
        this.valueCompensations = this.bigArrays().newDoubleArray(1L, true);
        this.weightCompensations = this.bigArrays().newDoubleArray(1L, true);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSources.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final SortedNumericDoubleValues docValues = this.valuesSources.getField(WeightedAvgAggregationBuilder.VALUE_FIELD.getPreferredName(), aggCtx.getLeafReaderContext());
        final SortedNumericDoubleValues docWeights = this.valuesSources.getField(WeightedAvgAggregationBuilder.WEIGHT_FIELD.getPreferredName(), aggCtx.getLeafReaderContext());
        final CompensatedSum compensatedValueSum = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedWeightSum = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, docValues){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                WeightedAvgAggregator.this.weights = WeightedAvgAggregator.this.bigArrays().grow(WeightedAvgAggregator.this.weights, bucket + 1L);
                WeightedAvgAggregator.this.valueSums = WeightedAvgAggregator.this.bigArrays().grow(WeightedAvgAggregator.this.valueSums, bucket + 1L);
                WeightedAvgAggregator.this.valueCompensations = WeightedAvgAggregator.this.bigArrays().grow(WeightedAvgAggregator.this.valueCompensations, bucket + 1L);
                WeightedAvgAggregator.this.weightCompensations = WeightedAvgAggregator.this.bigArrays().grow(WeightedAvgAggregator.this.weightCompensations, bucket + 1L);
                if (docValues.advanceExact(doc) && docWeights.advanceExact(doc)) {
                    if (docWeights.docValueCount() > 1) {
                        throw new IllegalArgumentException("Encountered more than one weight for a single document. Use a script to combine multiple weights-per-doc into a single value.");
                    }
                    assert (docWeights.docValueCount() == 1);
                    double weight = docWeights.nextValue();
                    int numValues = docValues.docValueCount();
                    assert (numValues > 0);
                    double valueSum = WeightedAvgAggregator.this.valueSums.get(bucket);
                    double valueCompensation = WeightedAvgAggregator.this.valueCompensations.get(bucket);
                    compensatedValueSum.reset(valueSum, valueCompensation);
                    double weightSum = WeightedAvgAggregator.this.weights.get(bucket);
                    double weightCompensation = WeightedAvgAggregator.this.weightCompensations.get(bucket);
                    compensatedWeightSum.reset(weightSum, weightCompensation);
                    for (int i = 0; i < numValues; ++i) {
                        compensatedValueSum.add(docValues.nextValue() * weight);
                        compensatedWeightSum.add(weight);
                    }
                    WeightedAvgAggregator.this.valueSums.set(bucket, compensatedValueSum.value());
                    WeightedAvgAggregator.this.valueCompensations.set(bucket, compensatedValueSum.delta());
                    WeightedAvgAggregator.this.weights.set(bucket, compensatedWeightSum.value());
                    WeightedAvgAggregator.this.weightCompensations.set(bucket, compensatedWeightSum.delta());
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.valueSums.size()) {
            return Double.NaN;
        }
        return this.valueSums.get(owningBucketOrd) / this.weights.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.valueSums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalWeightedAvg(this.name, this.valueSums.get(bucket), this.weights.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalWeightedAvg.empty(this.name, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.weights, this.valueSums, this.valueCompensations, this.weightCompensations});
    }
}

