/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptedMetricAggContexts;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.ScriptedMetric;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalScriptedMetric
extends InternalAggregation
implements ScriptedMetric {
    final Script reduceScript;
    private final List<Object> aggregations;

    InternalScriptedMetric(String name, List<Object> aggregations, Script reduceScript, Map<String, Object> metadata) {
        super(name, metadata);
        this.aggregations = aggregations;
        this.reduceScript = reduceScript;
    }

    public InternalScriptedMetric(StreamInput in) throws IOException {
        super(in);
        this.reduceScript = in.readOptionalWriteable(Script::new);
        this.aggregations = in.readCollectionAsList(StreamInput::readGenericValue);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.reduceScript);
        out.writeCollection(this.aggregations, StreamOutput::writeGenericValue);
    }

    @Override
    public String getWriteableName() {
        return "scripted_metric";
    }

    @Override
    public Object aggregation() {
        if (this.aggregations.size() != 1) {
            throw new IllegalStateException("aggregation was not reduced");
        }
        return this.aggregations.get(0);
    }

    List<Object> aggregationsList() {
        return this.aggregations;
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, int size) {
        return new AggregatorReducer(){
            final List<Object> aggregationObjects = new ArrayList<Object>();

            @Override
            public void accept(InternalAggregation aggregation) {
                this.aggregationObjects.addAll(((InternalScriptedMetric)aggregation).aggregationsList());
            }

            @Override
            public InternalAggregation get() {
                List<Object> aggregation;
                if (InternalScriptedMetric.this.reduceScript != null && reduceContext.isFinalReduce()) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    if (InternalScriptedMetric.this.reduceScript.getParams() != null) {
                        params.putAll(InternalScriptedMetric.this.reduceScript.getParams());
                    }
                    ScriptedMetricAggContexts.ReduceScript.Factory factory = reduceContext.scriptService().compile(InternalScriptedMetric.this.reduceScript, ScriptedMetricAggContexts.ReduceScript.CONTEXT);
                    ScriptedMetricAggContexts.ReduceScript script = factory.newInstance(params, this.aggregationObjects);
                    Object scriptResult = script.execute();
                    CollectionUtils.ensureNoSelfReferences(scriptResult, "reduce script");
                    aggregation = Collections.singletonList(scriptResult);
                } else {
                    aggregation = reduceContext.isFinalReduce() ? Collections.singletonList(this.aggregationObjects) : this.aggregationObjects;
                }
                return new InternalScriptedMetric(InternalScriptedMetric.this.getName(), aggregation, InternalScriptedMetric.this.reduceScript, InternalScriptedMetric.this.getMetadata());
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.aggregation();
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.aggregation());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalScriptedMetric other = (InternalScriptedMetric)obj;
        return Objects.equals(this.reduceScript, other.reduceScript) && Objects.equals(this.aggregations, other.aggregations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reduceScript, this.aggregations);
    }

    @Override
    public String toString() {
        return "InternalScriptedMetric{" + this.reduceScript + "}";
    }
}

