/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.PrioritizedThrottledTaskRunner;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.repositories.SnapshotShardContext;

public class ShardSnapshotTaskRunner {
    private static final Logger logger = LogManager.getLogger(ShardSnapshotTaskRunner.class);
    private final PrioritizedThrottledTaskRunner<SnapshotTask> taskRunner;
    private final Consumer<SnapshotShardContext> shardSnapshotter;
    private final CheckedBiConsumer<SnapshotShardContext, BlobStoreIndexShardSnapshot.FileInfo, IOException> fileSnapshotter;

    public ShardSnapshotTaskRunner(int maxRunningTasks, Executor executor, Consumer<SnapshotShardContext> shardSnapshotter, CheckedBiConsumer<SnapshotShardContext, BlobStoreIndexShardSnapshot.FileInfo, IOException> fileSnapshotter) {
        this.taskRunner = new PrioritizedThrottledTaskRunner("ShardSnapshotTaskRunner", maxRunningTasks, executor);
        this.shardSnapshotter = shardSnapshotter;
        this.fileSnapshotter = fileSnapshotter;
    }

    public void enqueueShardSnapshot(SnapshotShardContext context) {
        ShardSnapshotTask task = new ShardSnapshotTask(context);
        this.taskRunner.enqueueTask(task);
    }

    public void enqueueFileSnapshot(SnapshotShardContext context, Supplier<BlobStoreIndexShardSnapshot.FileInfo> fileInfos, ActionListener<Void> listener) {
        FileSnapshotTask task = new FileSnapshotTask(context, fileInfos, listener);
        this.taskRunner.enqueueTask(task);
    }

    int runningTasks() {
        return this.taskRunner.runningTasks();
    }

    int queueSize() {
        return this.taskRunner.queueSize();
    }

    class ShardSnapshotTask
    extends SnapshotTask {
        ShardSnapshotTask(SnapshotShardContext context) {
            super(context);
        }

        @Override
        public void doRun() {
            ShardSnapshotTaskRunner.this.shardSnapshotter.accept(this.context);
        }

        @Override
        public int priority() {
            return 1;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{snapshotID=[" + this.context.snapshotId() + "], indexID=[" + this.context.indexId() + "]}";
        }
    }

    class FileSnapshotTask
    extends SnapshotTask {
        private final Supplier<BlobStoreIndexShardSnapshot.FileInfo> fileInfos;
        private final ActionListener<Void> fileSnapshotListener;

        FileSnapshotTask(SnapshotShardContext context, Supplier<BlobStoreIndexShardSnapshot.FileInfo> fileInfos, ActionListener<Void> fileSnapshotListener) {
            super(context);
            this.fileInfos = fileInfos;
            this.fileSnapshotListener = fileSnapshotListener;
        }

        @Override
        public void doRun() {
            ActionRunnable.run(this.fileSnapshotListener, (CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                BlobStoreIndexShardSnapshot.FileInfo fileInfo = this.fileInfos.get();
                if (fileInfo != null) {
                    ShardSnapshotTaskRunner.this.fileSnapshotter.accept(this.context, fileInfo);
                }
            })).run();
        }

        @Override
        public int priority() {
            return 2;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{snapshotID=[" + this.context.snapshotId() + "], indexID=[" + this.context.indexId() + "]}";
        }
    }

    static abstract class SnapshotTask
    extends AbstractRunnable
    implements Comparable<SnapshotTask> {
        private static final Comparator<SnapshotTask> COMPARATOR = Comparator.comparingLong(t -> t.context().snapshotStartTime()).thenComparing(t -> t.context().snapshotId().getUUID()).thenComparingInt(SnapshotTask::priority);
        protected final SnapshotShardContext context;

        SnapshotTask(SnapshotShardContext context) {
            this.context = context;
        }

        public abstract int priority();

        public SnapshotShardContext context() {
            return this.context;
        }

        @Override
        public final int compareTo(SnapshotTask other) {
            return COMPARATOR.compare(this, other);
        }

        @Override
        public void onFailure(Exception e) {
            assert (false) : e;
            logger.error(Strings.format((String)"snapshot task [%s] unexpectedly failed", (Object[])new Object[]{this}), (Throwable)e);
        }
    }
}

