/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.spatial;

import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.index.PointValues;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;

public abstract class Component2DVisitor
extends TriangleTreeVisitor.TriangleTreeDecodedVisitor {
    protected final Component2D component2D;

    private Component2DVisitor(Component2D component2D, CoordinateEncoder encoder) {
        super(encoder);
        this.component2D = component2D;
    }

    public abstract boolean matches();

    public abstract void reset();

    @Override
    protected boolean pushDecodedX(double minX) {
        return this.component2D.getMaxX() >= minX;
    }

    @Override
    protected boolean pushDecodedY(double minY) {
        return this.component2D.getMaxY() >= minY;
    }

    @Override
    protected boolean pushDecoded(double maxX, double maxY) {
        return this.component2D.getMinX() <= maxX && this.component2D.getMinY() <= maxY;
    }

    @Override
    protected boolean pushDecoded(double minX, double minY, double maxX, double maxY) {
        return this.pushDecoded(this.component2D.relate(minX, maxX, minY, maxY));
    }

    protected abstract boolean pushDecoded(PointValues.Relation var1);

    public static Component2DVisitor getVisitor(Component2D component2D, ShapeField.QueryRelation relation, CoordinateEncoder encoder) {
        return switch (relation) {
            default -> throw new IncompatibleClassChangeError();
            case ShapeField.QueryRelation.CONTAINS -> new ContainsVisitor(component2D, encoder);
            case ShapeField.QueryRelation.INTERSECTS -> new IntersectsVisitor(component2D, encoder);
            case ShapeField.QueryRelation.DISJOINT -> new DisjointVisitor(component2D, encoder);
            case ShapeField.QueryRelation.WITHIN -> new WithinVisitor(component2D, encoder);
        };
    }

    private static class ContainsVisitor
    extends Component2DVisitor {
        Component2D.WithinRelation answer = Component2D.WithinRelation.DISJOINT;

        private ContainsVisitor(Component2D component2D, CoordinateEncoder encoder) {
            super(component2D, encoder);
        }

        @Override
        public boolean matches() {
            return this.answer == Component2D.WithinRelation.CANDIDATE;
        }

        @Override
        public void reset() {
            this.answer = Component2D.WithinRelation.DISJOINT;
        }

        @Override
        protected void visitDecodedPoint(double x, double y) {
            Component2D.WithinRelation rel = this.component2D.withinPoint(x, y);
            if (rel != Component2D.WithinRelation.DISJOINT) {
                this.answer = rel;
            }
        }

        @Override
        protected void visitDecodedLine(double aX, double aY, double bX, double bY, byte metadata) {
            boolean ab = TriangleTreeVisitor.abFromTriangle(metadata);
            Component2D.WithinRelation rel = this.component2D.withinLine(aX, aY, ab, bX, bY);
            if (rel != Component2D.WithinRelation.DISJOINT) {
                this.answer = rel;
            }
        }

        @Override
        protected void visitDecodedTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
            boolean ca;
            boolean bc;
            boolean ab = TriangleTreeVisitor.abFromTriangle(metadata);
            Component2D.WithinRelation rel = this.component2D.withinTriangle(aX, aY, ab, bX, bY, bc = TriangleTreeVisitor.bcFromTriangle(metadata), cX, cY, ca = TriangleTreeVisitor.caFromTriangle(metadata));
            if (rel != Component2D.WithinRelation.DISJOINT) {
                this.answer = rel;
            }
        }

        @Override
        public boolean push() {
            return this.answer != Component2D.WithinRelation.NOTWITHIN;
        }

        @Override
        protected boolean pushDecoded(PointValues.Relation relation) {
            return relation == PointValues.Relation.CELL_CROSSES_QUERY;
        }
    }

    private static class IntersectsVisitor
    extends Component2DVisitor {
        boolean intersects;

        private IntersectsVisitor(Component2D component2D, CoordinateEncoder encoder) {
            super(component2D, encoder);
        }

        @Override
        public boolean matches() {
            return this.intersects;
        }

        @Override
        public void reset() {
            this.intersects = false;
        }

        @Override
        protected void visitDecodedPoint(double x, double y) {
            this.intersects = this.component2D.contains(x, y);
        }

        @Override
        protected void visitDecodedLine(double aX, double aY, double bX, double bY, byte metadata) {
            this.intersects = this.component2D.intersectsLine(aX, aY, bX, bY);
        }

        @Override
        protected void visitDecodedTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
            this.intersects = this.component2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
        }

        @Override
        public boolean push() {
            return !this.intersects;
        }

        @Override
        protected boolean pushDecoded(PointValues.Relation relation) {
            if (relation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return false;
            }
            if (relation == PointValues.Relation.CELL_INSIDE_QUERY) {
                this.intersects = true;
                return false;
            }
            return true;
        }
    }

    private static class DisjointVisitor
    extends Component2DVisitor {
        boolean disjoint = true;

        private DisjointVisitor(Component2D component2D, CoordinateEncoder encoder) {
            super(component2D, encoder);
        }

        @Override
        public boolean matches() {
            return this.disjoint;
        }

        @Override
        public void reset() {
            this.disjoint = true;
        }

        @Override
        protected void visitDecodedPoint(double x, double y) {
            this.disjoint = !this.component2D.contains(x, y);
        }

        @Override
        protected void visitDecodedLine(double aX, double aY, double bX, double bY, byte metadata) {
            this.disjoint = !this.component2D.intersectsLine(aX, aY, bX, bY);
        }

        @Override
        protected void visitDecodedTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
            this.disjoint = !this.component2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
        }

        @Override
        public boolean push() {
            return this.disjoint;
        }

        @Override
        protected boolean pushDecoded(PointValues.Relation relation) {
            if (relation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return false;
            }
            if (relation == PointValues.Relation.CELL_INSIDE_QUERY) {
                this.disjoint = false;
                return false;
            }
            return true;
        }
    }

    private static class WithinVisitor
    extends Component2DVisitor {
        boolean within = true;

        private WithinVisitor(Component2D component2D, CoordinateEncoder encoder) {
            super(component2D, encoder);
        }

        @Override
        public boolean matches() {
            return this.within;
        }

        @Override
        public void reset() {
            this.within = true;
        }

        @Override
        protected void visitDecodedPoint(double x, double y) {
            this.within = this.component2D.contains(x, y);
        }

        @Override
        protected void visitDecodedLine(double aX, double aY, double bX, double bY, byte metadata) {
            this.within = this.component2D.containsLine(aX, aY, bX, bY);
        }

        @Override
        protected void visitDecodedTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
            this.within = this.component2D.containsTriangle(aX, aY, bX, bY, cX, cY);
        }

        @Override
        public boolean push() {
            return this.within;
        }

        @Override
        protected boolean pushDecodedX(double minX) {
            this.within = super.pushDecodedX(minX);
            return this.within;
        }

        @Override
        protected boolean pushDecodedY(double minY) {
            this.within = super.pushDecodedY(minY);
            return this.within;
        }

        @Override
        protected boolean pushDecoded(double maxX, double maxY) {
            this.within = super.pushDecoded(maxX, maxY);
            return this.within;
        }

        @Override
        protected boolean pushDecoded(PointValues.Relation relation) {
            if (relation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                this.within = false;
            }
            return this.within;
        }
    }
}

