/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.env.BuildVersion;

final class DefaultBuildVersion
extends BuildVersion {
    public static BuildVersion CURRENT = new DefaultBuildVersion(Version.CURRENT.id());
    private final int versionId;
    private final Version version;

    DefaultBuildVersion(int versionId) {
        assert (versionId >= 0) : "Release version IDs must be non-negative integers";
        this.versionId = versionId;
        this.version = Version.fromId(versionId);
    }

    @Override
    public boolean onOrAfterMinimumCompatible() {
        return Version.CURRENT.minimumCompatibilityVersion().onOrBefore(this.version);
    }

    @Override
    public boolean isFutureVersion() {
        return Version.CURRENT.before(this.version);
    }

    @Override
    public int id() {
        return this.versionId;
    }

    @Override
    public Version toVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultBuildVersion that = (DefaultBuildVersion)o;
        return this.versionId == that.versionId;
    }

    public int hashCode() {
        return Objects.hash(this.versionId);
    }

    public String toString() {
        return Version.fromId(this.versionId).toString();
    }
}

