/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.atomic.AtomicInteger;

public final class CountDown {
    private final AtomicInteger countDown;

    public CountDown(int count) {
        if (count <= 0) {
            String message = "count must be greater than 0 but was: " + count;
            assert (false) : message;
            throw new IllegalArgumentException(message);
        }
        this.countDown = new AtomicInteger(count);
    }

    private static int assertValidCount(int count) {
        assert (count >= 0) : count;
        return count;
    }

    public boolean countDown() {
        return this.countDown.getAndUpdate(current -> CountDown.assertValidCount(current) == 0 ? 0 : current - 1) == 1;
    }

    public boolean fastForward() {
        return CountDown.assertValidCount(this.countDown.getAndSet(0)) > 0;
    }

    public boolean isCountedDown() {
        return CountDown.assertValidCount(this.countDown.get()) == 0;
    }
}

