/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateTimeParser;
import org.elasticsearch.common.time.DateTimePrinter;
import org.elasticsearch.common.time.JavaDateMathParser;
import org.elasticsearch.common.time.JavaTimeDateTimeParser;

class JavaDateFormatter
implements DateFormatter {
    private final String format;
    private final DateTimePrinter printer;
    private final DateTimeParser[] parsers;
    final DateTimeParser[] roundupParsers;

    private static <T extends DateTimeParser> T defaultRoundUp(T parser) {
        if (parser instanceof JavaTimeDateTimeParser) {
            JavaTimeDateTimeParser jtp = (JavaTimeDateTimeParser)parser;
            return (T)JavaDateFormatter.defaultRoundUp(jtp);
        }
        throw new IllegalArgumentException("Unknown parser implementation " + parser.getClass());
    }

    private static JavaTimeDateTimeParser defaultRoundUp(JavaTimeDateTimeParser parser) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(parser.formatter());
        String parserAsString = parser.formatter().toString();
        if (parserAsString.contains(ChronoField.DAY_OF_YEAR.toString())) {
            builder.parseDefaulting(ChronoField.DAY_OF_YEAR, 1L);
        } else if (!parserAsString.contains(IsoFields.WEEK_BASED_YEAR.toString())) {
            builder.parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L);
            builder.parseDefaulting(ChronoField.DAY_OF_MONTH, 1L);
        }
        if (parserAsString.contains(ChronoField.CLOCK_HOUR_OF_AMPM.toString())) {
            builder.parseDefaulting(ChronoField.CLOCK_HOUR_OF_AMPM, 11L);
            builder.parseDefaulting(ChronoField.AMPM_OF_DAY, 1L);
        } else if (parserAsString.contains(ChronoField.HOUR_OF_AMPM.toString())) {
            builder.parseDefaulting(ChronoField.HOUR_OF_AMPM, 11L);
            builder.parseDefaulting(ChronoField.AMPM_OF_DAY, 1L);
        } else {
            builder.parseDefaulting(ChronoField.HOUR_OF_DAY, 23L);
        }
        builder.parseDefaulting(ChronoField.MINUTE_OF_HOUR, 59L);
        builder.parseDefaulting(ChronoField.SECOND_OF_MINUTE, 59L);
        builder.parseDefaulting(ChronoField.NANO_OF_SECOND, 999999999L);
        return new JavaTimeDateTimeParser(builder.toFormatter(parser.getLocale()));
    }

    JavaDateFormatter(String format, DateTimePrinter printer, DateTimeParser ... parsers) {
        this(format, printer, JavaDateFormatter::defaultRoundUp, parsers);
    }

    @SafeVarargs
    <T extends DateTimeParser> JavaDateFormatter(String format, DateTimePrinter printer, UnaryOperator<T> generateRoundUpParser, T ... parsers) {
        if (format.contains("||")) {
            throw new IllegalArgumentException("This class cannot handle multiple format specifiers");
        }
        if (printer == null) {
            throw new IllegalArgumentException("printer may not be null");
        }
        if (parsers.length == 0) {
            throw new IllegalArgumentException("parsers need to be specified");
        }
        JavaDateFormatter.verifyPrinterParsers(printer, parsers);
        this.printer = printer;
        this.format = format;
        this.parsers = (DateTimeParser[])Arrays.copyOf(parsers, parsers.length, DateTimeParser[].class);
        this.roundupParsers = JavaDateFormatter.mapParsers(generateRoundUpParser, parsers);
    }

    private static void verifyPrinterParsers(DateTimePrinter printer, DateTimeParser[] parsers) {
        ZoneId zoneId = printer.getZone();
        Locale locale = printer.getLocale();
        for (DateTimeParser parser : parsers) {
            if (!Objects.equals(parser.getZone(), zoneId)) {
                throw new IllegalArgumentException("formatters must have the same time zone");
            }
            if (Objects.equals(parser.getLocale(), locale)) continue;
            throw new IllegalArgumentException("formatters must have the same locale");
        }
    }

    static DateFormatter combined(String input, List<DateFormatter> formatters) {
        assert (!formatters.isEmpty());
        DateTimePrinter printer = null;
        ArrayList parsers = new ArrayList(formatters.size());
        ArrayList roundUpParsers = new ArrayList(formatters.size());
        for (DateFormatter formatter : formatters) {
            JavaDateFormatter javaDateFormatter = (JavaDateFormatter)formatter;
            if (printer == null) {
                printer = javaDateFormatter.printer;
            }
            Collections.addAll(parsers, javaDateFormatter.parsers);
            Collections.addAll(roundUpParsers, javaDateFormatter.roundupParsers);
        }
        return new JavaDateFormatter(input, printer, (DateTimeParser[])roundUpParsers.toArray(DateTimeParser[]::new), (DateTimeParser[])parsers.toArray(DateTimeParser[]::new));
    }

    private JavaDateFormatter(String format, DateTimePrinter printer, DateTimeParser[] roundupParsers, DateTimeParser[] parsers) {
        this.format = format;
        this.printer = printer;
        this.roundupParsers = roundupParsers;
        this.parsers = parsers;
    }

    TemporalAccessor roundupParse(String input) {
        if (Strings.isNullOrEmpty(input)) {
            throw new IllegalArgumentException("cannot parse empty datetime");
        }
        try {
            return JavaDateFormatter.doParse(input, this.roundupParsers);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse date field [" + input + "] with format [" + this.format + "]", e);
        }
    }

    @Override
    public TemporalAccessor parse(String input) {
        if (Strings.isNullOrEmpty(input)) {
            throw new IllegalArgumentException("cannot parse empty datetime");
        }
        try {
            return JavaDateFormatter.doParse(input, this.parsers);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse date field [" + input + "] with format [" + this.format + "]", e);
        }
    }

    private static TemporalAccessor doParse(String input, DateTimeParser[] parsers) {
        if (parsers.length > 1) {
            for (DateTimeParser formatter : parsers) {
                Optional<TemporalAccessor> result = formatter.tryParse(input);
                if (!result.isPresent()) continue;
                return result.get();
            }
            throw new DateTimeParseException("Failed to parse with all enclosed parsers", input, 0);
        }
        return parsers[0].parse(input);
    }

    @Override
    public DateFormatter withZone(ZoneId zoneId) {
        if (zoneId.equals(this.zone())) {
            return this;
        }
        return this.mapParsers(p -> p.withZone(zoneId), p -> p.withZone(zoneId));
    }

    @Override
    public DateFormatter withLocale(Locale locale) {
        if (locale.equals(this.locale())) {
            return this;
        }
        return this.mapParsers(p -> p.withLocale(locale), p -> p.withLocale(locale));
    }

    private JavaDateFormatter mapParsers(UnaryOperator<DateTimePrinter> printerMapping, UnaryOperator<DateTimeParser> parserMapping) {
        return new JavaDateFormatter(this.format, (DateTimePrinter)printerMapping.apply(this.printer), JavaDateFormatter.mapParsers(parserMapping, (DateTimeParser[])this.roundupParsers), JavaDateFormatter.mapParsers(parserMapping, (DateTimeParser[])this.parsers));
    }

    @SafeVarargs
    private static <T extends DateTimeParser> DateTimeParser[] mapParsers(UnaryOperator<T> mapping, T ... objects) {
        DateTimeParser[] res = new DateTimeParser[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            res[i] = (DateTimeParser)mapping.apply(objects[i]);
        }
        return res;
    }

    @Override
    public String format(TemporalAccessor accessor) {
        return this.printer.format(DateFormatters.from(accessor));
    }

    @Override
    public String pattern() {
        return this.format;
    }

    @Override
    public Locale locale() {
        return this.printer.getLocale();
    }

    @Override
    public ZoneId zone() {
        return this.printer.getZone();
    }

    @Override
    public DateMathParser toDateMathParser() {
        return new JavaDateMathParser(this.format, this::parse, this::roundupParse);
    }

    public int hashCode() {
        return Objects.hash(this.locale(), this.printer.getZone(), this.format);
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaDateFormatter other = (JavaDateFormatter)obj;
        return Objects.equals(this.format, other.format) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.printer.getZone(), other.printer.getZone());
    }

    public String toString() {
        return String.format(Locale.ROOT, "format[%s] locale[%s]", this.format, this.locale());
    }
}

