/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;

public class Queries {
    private static final IndexVersion NESTED_DOCS_IDENTIFIED_VIA_PRIMARY_TERMS_VERSION = IndexVersion.fromId(6010099);
    private static final Pattern spaceAroundLessThanPattern = Pattern.compile("(\\s+<\\s*)|(\\s*<\\s+)");
    private static final Pattern spacePattern = Pattern.compile(" ");
    private static final Pattern lessThanPattern = Pattern.compile("<");

    public static Query newMatchAllQuery() {
        return new MatchAllDocsQuery();
    }

    public static Query newMatchNoDocsQuery(String reason) {
        return new MatchNoDocsQuery(reason);
    }

    public static Query newUnmappedFieldQuery(String field) {
        return Queries.newUnmappedFieldsQuery(Collections.singletonList(field));
    }

    public static Query newUnmappedFieldsQuery(Collection<String> fields) {
        return Queries.newMatchNoDocsQuery("unmapped fields " + fields);
    }

    public static Query newLenientFieldQuery(String field, RuntimeException e) {
        String message = ElasticsearchException.getExceptionName(e) + ":[" + e.getMessage() + "]";
        return Queries.newMatchNoDocsQuery("failed [" + field + "] query, caused by " + message);
    }

    public static Query newNestedFilter(IndexVersion indexVersionCreated) {
        if (indexVersionCreated.onOrAfter(NESTED_DOCS_IDENTIFIED_VIA_PRIMARY_TERMS_VERSION)) {
            return Queries.not(Queries.newNonNestedFilter(indexVersionCreated));
        }
        return new PrefixQuery(new Term("_type", new BytesRef((CharSequence)"__")));
    }

    public static Query newNonNestedFilter(IndexVersion indexVersionCreated) {
        if (indexVersionCreated.onOrAfter(NESTED_DOCS_IDENTIFIED_VIA_PRIMARY_TERMS_VERSION)) {
            return new FieldExistsQuery("_primary_term");
        }
        return Queries.not(Queries.newNestedFilter(indexVersionCreated));
    }

    public static BooleanQuery filtered(@Nullable Query query, @Nullable Query filter) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (query != null) {
            builder.add(new BooleanClause(query, BooleanClause.Occur.MUST));
        }
        if (filter != null) {
            builder.add(new BooleanClause(filter, BooleanClause.Occur.FILTER));
        }
        return builder.build();
    }

    public static Query not(Query q) {
        return new BooleanQuery.Builder().add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST).add(q, BooleanClause.Occur.MUST_NOT).build();
    }

    static boolean isNegativeQuery(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return false;
        }
        List clauses = ((BooleanQuery)q).clauses();
        return !clauses.isEmpty() && clauses.stream().allMatch(BooleanClause::isProhibited);
    }

    public static Query fixNegativeQueryIfNeeded(Query q) {
        if (Queries.isNegativeQuery(q)) {
            BooleanQuery bq = (BooleanQuery)q;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (BooleanClause clause : bq) {
                builder.add(clause);
            }
            builder.add(Queries.newMatchAllQuery(), BooleanClause.Occur.FILTER);
            return builder.build();
        }
        return q;
    }

    public static Query applyMinimumShouldMatch(BooleanQuery query, @Nullable String minimumShouldMatch) {
        if (minimumShouldMatch == null) {
            return query;
        }
        int optionalClauses = 0;
        for (BooleanClause c : query.clauses()) {
            if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
            ++optionalClauses;
        }
        int msm = Queries.calculateMinShouldMatch(optionalClauses, minimumShouldMatch);
        if (0 < msm) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (BooleanClause clause : query) {
                builder.add(clause);
            }
            builder.setMinimumNumberShouldMatch(msm);
            return builder.build();
        }
        return query;
    }

    public static Query maybeApplyMinimumShouldMatch(Query query, @Nullable String minimumShouldMatch) {
        if (query instanceof BooleanQuery) {
            return Queries.applyMinimumShouldMatch((BooleanQuery)query, minimumShouldMatch);
        }
        return query;
    }

    public static int calculateMinShouldMatch(int optionalClauseCount, String spec) {
        int calc;
        int percent;
        float calc2;
        int result = optionalClauseCount;
        if ((spec = spec.trim()).contains("<")) {
            spec = spaceAroundLessThanPattern.matcher(spec).replaceAll("<");
            for (String s : spacePattern.split(spec)) {
                String[] parts = lessThanPattern.split(s, 0);
                int upperBound = Integer.parseInt(parts[0]);
                if (optionalClauseCount <= upperBound) {
                    return result;
                }
                result = Queries.calculateMinShouldMatch(optionalClauseCount, parts[1]);
            }
            return result;
        }
        result = -1 < spec.indexOf(37) ? ((calc2 = (float)(result * (percent = Integer.parseInt(spec = spec.substring(0, spec.length() - 1)))) * 0.01f) < 0.0f ? result + (int)calc2 : (int)calc2) : ((calc = Integer.parseInt(spec)) < 0 ? result + calc : calc);
        return Math.max(result, 0);
    }
}

