/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.util.List;
import java.util.SortedMap;
import java.util.stream.Stream;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.index.Index;

public class DataStreamsActionUtil {
    public static List<String> getDataStreamNames(IndexNameExpressionResolver indexNameExpressionResolver, ClusterState currentState, String[] names, IndicesOptions indicesOptions) {
        indicesOptions = DataStreamsActionUtil.updateIndicesOptions(indicesOptions);
        return indexNameExpressionResolver.dataStreamNames(currentState, indicesOptions, names);
    }

    public static IndicesOptions updateIndicesOptions(IndicesOptions indicesOptions) {
        if (!indicesOptions.expandWildcardsOpen()) {
            indicesOptions = IndicesOptions.builder(indicesOptions).wildcardOptions(IndicesOptions.WildcardOptions.builder(indicesOptions.wildcardOptions()).matchOpen(true)).build();
        }
        return indicesOptions;
    }

    public static Stream<String> resolveConcreteIndexNames(IndexNameExpressionResolver indexNameExpressionResolver, ClusterState clusterState, String[] names, IndicesOptions indicesOptions) {
        List<String> abstractionNames = DataStreamsActionUtil.getDataStreamNames(indexNameExpressionResolver, clusterState, names, indicesOptions);
        SortedMap<String, IndexAbstraction> indicesLookup = clusterState.getMetadata().getIndicesLookup();
        return abstractionNames.stream().flatMap(abstractionName -> {
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(abstractionName);
            assert (indexAbstraction != null);
            if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
                DataStream dataStream = (DataStream)indexAbstraction;
                List<Index> indices = dataStream.getIndices();
                return indices.stream().map(Index::getName);
            }
            return Stream.empty();
        });
    }
}

