/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class OptimalShardCountCondition
extends Condition<Integer> {
    public static final String NAME = "optimal_shard_count";

    public OptimalShardCountCondition(int optimalShards) {
        super(NAME, Condition.Type.AUTOMATIC);
        this.value = optimalShards;
    }

    public OptimalShardCountCondition(StreamInput in) throws IOException {
        super(NAME, Condition.Type.AUTOMATIC);
        this.value = in.readVInt();
    }

    @Override
    public Condition.Result evaluate(Condition.Stats stats) {
        return new Condition.Result(this, true);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt((Integer)this.value);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(NAME, (Integer)this.value);
    }

    public static OptimalShardCountCondition fromXContent(XContentParser parser) throws IOException {
        if (parser.nextToken() == XContentParser.Token.VALUE_NUMBER) {
            return new OptimalShardCountCondition(parser.intValue());
        }
        throw new IllegalArgumentException("invalid token when parsing optimal_shard_count condition: " + parser.currentToken());
    }

    @Override
    boolean includedInVersion(TransportVersion version) {
        return version.onOrAfter(TransportVersions.AUTO_SHARDING_ROLLOVER_CONDITION);
    }
}

