/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.util.Map;
import java.util.function.BiConsumer;

public final class MappingVisitor {
    private MappingVisitor() {
    }

    public static void visitMapping(Map<String, ?> mapping, BiConsumer<String, Map<String, ?>> fieldMappingConsumer) {
        MappingVisitor.visitMapping(mapping, "", fieldMappingConsumer);
    }

    private static void visitMapping(Map<String, ?> mapping, String path, BiConsumer<String, Map<String, ?>> fieldMappingConsumer) {
        Object properties = mapping.get("properties");
        if (properties instanceof Map) {
            Map propertiesAsMap = (Map)properties;
            for (Map.Entry entry : propertiesAsMap.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof Map)) continue;
                Map fieldMapping = (Map)v;
                String prefix = path + (String)entry.getKey();
                fieldMappingConsumer.accept(prefix, fieldMapping);
                MappingVisitor.visitMapping(fieldMapping, prefix + ".", fieldMappingConsumer);
                Object fieldsO = fieldMapping.get("fields");
                if (!(fieldsO instanceof Map)) continue;
                Map fields = (Map)fieldsO;
                for (Map.Entry subfieldEntry : fields.entrySet()) {
                    Object v2 = subfieldEntry.getValue();
                    if (!(v2 instanceof Map)) continue;
                    Map fieldMapping2 = (Map)v2;
                    fieldMappingConsumer.accept(prefix + "." + (String)subfieldEntry.getKey(), fieldMapping2);
                }
            }
        }
    }

    public static void visitRuntimeMapping(Map<String, ?> mapping, BiConsumer<String, Map<String, ?>> runtimeFieldMappingConsumer) {
        Object runtimeObject = mapping.get("runtime");
        if (!(runtimeObject instanceof Map)) {
            return;
        }
        Map runtimeMappings = (Map)runtimeObject;
        for (Map.Entry entry : runtimeMappings.entrySet()) {
            Object runtimeFieldMappingObject = entry.getValue();
            if (!(runtimeFieldMappingObject instanceof Map)) continue;
            Map runtimeFieldMapping = (Map)runtimeFieldMappingObject;
            runtimeFieldMappingConsumer.accept((String)entry.getKey(), runtimeFieldMapping);
        }
    }
}

