/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import org.geotools.api.style.Description;
import org.geotools.api.util.InternationalString;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.util.SimpleInternationalString;

public class DescriptionBuilder
extends AbstractStyleBuilder<Description> {
    private InternationalString title;
    private InternationalString description;

    public DescriptionBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public DescriptionBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    @Override
    public Description build() {
        if (this.unset) {
            return null;
        }
        Description descript = this.sf.description(this.title, this.description);
        if (this.parent == null) {
            this.reset();
        }
        return descript;
    }

    public DescriptionBuilder reset() {
        this.unset = false;
        this.title = null;
        this.description = null;
        return this;
    }

    public DescriptionBuilder title(InternationalString title) {
        this.title = title;
        this.unset = false;
        return this;
    }

    public DescriptionBuilder title(String title) {
        return this.title((InternationalString)new SimpleInternationalString(title));
    }

    public DescriptionBuilder description(InternationalString description) {
        this.description = description;
        this.unset = false;
        return this;
    }

    public DescriptionBuilder description(String description) {
        return this.description((InternationalString)new SimpleInternationalString(description));
    }

    public DescriptionBuilder reset(Description original) {
        this.unset = false;
        this.title = original.getTitle();
        this.description = original.getAbstract();
        return this;
    }

    @Override
    public DescriptionBuilder unset() {
        this.unset = true;
        this.title = null;
        this.description = null;
        return this;
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        throw new UnsupportedOperationException("Does not make sense to build a style out of a description");
    }
}

