/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.listener.metadata.draft;

import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.events.history.RecordUpdatedEvent;
import org.fao.geonet.events.md.MetadataStatusChanged;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.listener.metadata.draft.DraftUtilities;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class ApproveRecord
implements ApplicationListener<MetadataStatusChanged> {
    @Autowired
    private MetadataDraftRepository metadataDraftRepository;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private IMetadataStatus metadataStatus;
    @Autowired
    private DraftUtilities draftUtilities;
    @Autowired
    IMetadataUtils metadataUtils;

    public void onApplicationEvent(MetadataStatusChanged event) {
    }

    @TransactionalEventListener(phase=TransactionPhase.BEFORE_COMMIT)
    public void doAfterCommit(MetadataStatusChanged event) {
        try {
            Log.trace((String)"geonetwork.datamanager", (Object)("Status changed for metadata with id " + event.getMd().getId()));
            StatusValue status = event.getStatus();
            switch (String.valueOf(status.getId())) {
                case "1": 
                case "4": {
                    if (!(event.getMd() instanceof Metadata)) break;
                    Log.trace((String)"geonetwork.datamanager", (Object)("Replacing contents of record (ID=" + event.getMd().getId() + ") with draft, if exists."));
                    this.draftUtilities.replaceMetadataWithDraft(event.getMd());
                    break;
                }
                case "3": {
                    try {
                        Log.trace((String)"geonetwork.datamanager", (Object)("Removing draft from record (ID=" + event.getMd().getId() + "), if exists."));
                        this.removeDraft(event.getMd());
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.datamanager", (String)"Error upgrading status", (Throwable)e);
                    }
                    break;
                }
                case "2": {
                    try {
                        Log.trace((String)"geonetwork.datamanager", (Object)("Replacing contents of approved record (ID=" + event.getMd().getId() + ") with draft, if exists."));
                        this.approveWithDraft(event);
                        break;
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.datamanager", (String)"Error upgrading status", (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable e) {
            Log.error((String)"geonetwork.datamanager", (String)("Error changing workflow status of " + event.getMd()), (Throwable)e);
        }
    }

    private void removeDraft(AbstractMetadata md) throws Exception {
        if (!(md instanceof MetadataDraft)) {
            md = this.metadataDraftRepository.findOneByUuid(md.getUuid());
        }
        if (md != null) {
            this.draftUtilities.removeDraft((MetadataDraft)md);
        }
    }

    private AbstractMetadata approveWithDraft(MetadataStatusChanged event) throws NumberFormatException, Exception {
        AbstractMetadata md = event.getMd();
        AbstractMetadata draft = null;
        if (md instanceof MetadataDraft) {
            draft = md;
            md = this.metadataRepository.findOneByUuid(draft.getUuid());
            MetadataStatus status = new MetadataStatus();
            status.setChangeMessage(event.getMessage());
            status.setStatusValue(event.getStatus());
            status.setMetadataId(md.getId());
            status.setUuid(md.getUuid());
            status.setTitles(this.metadataUtils.extractTitles(Integer.toString(md.getId())));
            status.setChangeDate(new ISODate());
            status.setUserId(event.getUser().intValue());
            this.metadataStatus.setStatusExt(status, false);
        } else if (md instanceof Metadata) {
            draft = null;
        }
        if (draft != null) {
            Log.trace((String)"geonetwork.datamanager", (Object)("Approving record " + md.getId() + " which has a draft " + draft.getId()));
            XMLOutputter outp = new XMLOutputter();
            String xmlBefore = outp.outputString(md.getXmlData(false));
            md = this.draftUtilities.replaceMetadataWithDraft(md, draft);
            Element afterMetadata = draft.getXmlData(false);
            String xmlAfter = outp.outputString(afterMetadata);
            new RecordUpdatedEvent(Integer.valueOf(md.getId()), event.getUser(), xmlBefore, xmlAfter).publish((ApplicationContext)ApplicationContextHolder.get());
        }
        return md;
    }
}

