/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.Address;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.security.openidconnect.OIDCConfiguration;
import org.fao.geonet.kernel.security.openidconnect.OIDCRoleProcessor;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;

public class SimpleOidcUser {
    private String username;
    private String firstname;
    private String surname;
    private String organisation;
    private String profile;
    private String email;
    private Address address;

    public SimpleOidcUser(OIDCConfiguration oidcConfiguration, OIDCRoleProcessor oidcRoleProcessor, OidcIdToken idToken, Map userAttributes) throws Exception {
        Map attributes = userAttributes == null ? new HashMap() : userAttributes;
        this.username = (String)idToken.getClaims().get(oidcConfiguration.getUserNameAttribute());
        if (this.username == null) {
            this.username = (String)attributes.get(oidcConfiguration.getUserNameAttribute());
        }
        if (this.username == null) {
            this.username = idToken.getPreferredUsername();
        }
        if (this.username == null) {
            this.username = (String)attributes.get("preferred_username");
        }
        if (this.username == null) {
            this.username = idToken.getEmail();
        }
        if (this.username == null) {
            this.username = (String)attributes.get("email");
        }
        if (this.username == null) {
            throw new Exception("OIDC: could not extract user ID from ID Token or userinfo.  tried PREFERRED_USERNAME, EMAIL, and " + oidcConfiguration.getUserNameAttribute());
        }
        this.username = StringUtils.left((String)this.username, (int)256);
        if (!StringUtils.isBlank((String)this.username)) {
            Map<Profile, List<String>> profileGroups;
            this.surname = idToken.getFamilyName();
            if (this.surname == null && attributes.containsKey("family_name")) {
                this.surname = (String)attributes.get("family_name");
            }
            this.firstname = idToken.getGivenName();
            if (this.firstname == null && attributes.containsKey("given_name")) {
                this.firstname = (String)attributes.get("given_name");
            }
            this.email = idToken.getEmail();
            if (this.email == null && attributes.containsKey("email")) {
                this.email = (String)attributes.get("email");
            }
            if (idToken.getClaims() != null && idToken.getClaims().containsKey(oidcConfiguration.getOrganizationProperty())) {
                this.organisation = (String)idToken.getClaims().get(oidcConfiguration.getOrganizationProperty());
            }
            if (this.organisation == null && attributes.containsKey(oidcConfiguration.getOrganizationProperty())) {
                this.organisation = (String)attributes.get(oidcConfiguration.getOrganizationProperty());
            }
            if (idToken.getAddress() != null) {
                this.address = new Address();
                this.address.setAddress(idToken.getAddress().getStreetAddress());
                this.address.setCity(idToken.getAddress().getLocality());
                this.address.setState(idToken.getAddress().getRegion());
                this.address.setZip(idToken.getAddress().getPostalCode());
                this.address.setCountry(idToken.getAddress().getCountry());
            }
            if ((profileGroups = oidcRoleProcessor.getProfileGroups(idToken)) != null && profileGroups.size() > 0) {
                this.profile = oidcRoleProcessor.getMaxProfile(profileGroups).name();
            }
        }
    }

    public SimpleOidcUser(OIDCConfiguration oidcConfiguration, OIDCRoleProcessor oidcRoleProcessor, Map attributes) throws Exception {
        this.username = (String)attributes.get(oidcConfiguration.getUserNameAttribute());
        if (this.username == null) {
            this.username = (String)attributes.get("preferred_username");
        }
        if (this.username == null) {
            this.username = (String)attributes.get("email");
        }
        if (this.username == null) {
            throw new Exception("OIDC: could not extract user ID from ID Token or userinfo.  tried PREFERRED_USERNAME, EMAIL, and " + oidcConfiguration.getUserNameAttribute());
        }
        if (this.username == null) {
            this.username = (String)attributes.get("name");
        }
        if (this.username != null) {
            this.username = StringUtils.left((String)this.username, (int)256);
        }
        if (!StringUtils.isEmpty((String)this.username)) {
            Map<Profile, List<String>> profileGroups;
            this.surname = (String)attributes.get("family_name");
            this.firstname = (String)attributes.get("given_name");
            this.email = (String)attributes.get("email");
            if (attributes.containsKey(oidcConfiguration.getOrganizationProperty())) {
                this.organisation = (String)attributes.get(oidcConfiguration.getOrganizationProperty());
            }
            if ((profileGroups = oidcRoleProcessor.getProfileGroups(attributes)) != null && profileGroups.size() > 0) {
                this.profile = oidcRoleProcessor.getMaxProfile(profileGroups).name();
            }
        }
    }

    public void updateUser(User user) {
        if (!StringUtils.isEmpty((String)this.getSurname())) {
            user.setSurname(this.getSurname());
        }
        if (!StringUtils.isEmpty((String)this.getFirstname())) {
            user.setName(this.getFirstname());
        }
        if (!StringUtils.isEmpty((String)this.getOrganisation())) {
            user.setOrganisation(this.getOrganisation());
        }
        if (!StringUtils.isEmpty((String)this.getEmail()) && !user.getEmailAddresses().contains(this.getEmail())) {
            user.getEmailAddresses().clear();
            user.getEmailAddresses().add(this.getEmail());
        }
        if (this.getAddress() != null) {
            Address address = user.getAddresses().size() > 0 ? (Address)user.getAddresses().iterator().next() : new Address();
            address.setAddress(this.getAddress().getAddress());
            address.setCity(this.getAddress().getCity());
            address.setState(this.getAddress().getState());
            address.setZip(this.getAddress().getZip());
            address.setCountry(this.getAddress().getCountry());
            user.getAddresses().clear();
            user.getAddresses().add(address);
        }
        if (!StringUtils.isEmpty((String)this.getProfile())) {
            user.setProfile(Profile.findProfileIgnoreCase((String)this.getProfile()));
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }
}

