/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.io.IOException;
import java.time.Instant;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;

public class SessionExpirationFilter
implements Filter {
    @Autowired
    private OAuth2AuthorizedClientManager authorizedClientManager;
    @Autowired
    private OAuth2AuthorizedClientRepository authorizedClientRepository;
    private static final Logger log = LoggerFactory.getLogger(SessionExpirationFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        OAuth2AccessToken accessToken;
        OAuth2AuthenticationToken oauth2Token;
        OAuth2AuthorizedClient authorizedClient;
        Authentication authentication;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession httpSession = httpRequest.getSession(false);
        if (httpSession != null && !response.isCommitted() && (authentication = SecurityContextHolder.getContext().getAuthentication()) instanceof OAuth2AuthenticationToken && (authorizedClient = this.authorizedClientRepository.loadAuthorizedClient((oauth2Token = (OAuth2AuthenticationToken)authentication).getAuthorizedClientRegistrationId(), (Authentication)oauth2Token, httpRequest)) != null && (accessToken = authorizedClient.getAccessToken()) != null && accessToken.getExpiresAt() != null && accessToken.getExpiresAt().isBefore(Instant.now())) {
            try {
                authorizedClient = this.authorizedClientManager.authorize(OAuth2AuthorizeRequest.withClientRegistrationId((String)oauth2Token.getAuthorizedClientRegistrationId()).principal((Authentication)oauth2Token).build());
                if (authorizedClient == null || authorizedClient.getAccessToken() == null) {
                    log.warn("Session '{}' for user '{}' is expired due to terminated/expired authentication server session.", (Object)httpSession.getId(), (Object)oauth2Token.getPrincipal().getName());
                    httpRequest.logout();
                    SecurityContextHolder.getContext().setAuthentication(null);
                    httpSession.invalidate();
                }
            }
            catch (ClientAuthorizationException e) {
                log.warn("Authorization exception occurred for session '{}' for user '{}'.", new Object[]{httpSession.getId(), oauth2Token.getPrincipal().getName(), e});
                httpRequest.logout();
                SecurityContextHolder.getContext().setAuthentication(null);
                httpSession.invalidate();
            }
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void destroy() {
    }
}

