/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.listener;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fao.geonet.ApplicationContextHolder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.web.session.HttpSessionCreatedEvent;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HttpSessionEventPublisher
implements HttpSessionListener {
    private static final String LOGGER_NAME = org.springframework.security.web.session.HttpSessionEventPublisher.class.getName();

    ApplicationContext getContext(ServletContext servletContext) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (applicationContext == null) {
            applicationContext = ApplicationContextHolder.get();
        }
        return applicationContext;
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSessionCreatedEvent e = new HttpSessionCreatedEvent(event.getSession());
        Log log = LogFactory.getLog((String)LOGGER_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Publishing event: " + e));
        }
        this.getContext(event.getSession().getServletContext()).publishEvent((ApplicationEvent)e);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        ApplicationContext applicationContext;
        HttpSessionDestroyedEvent e = new HttpSessionDestroyedEvent(event.getSession());
        Log log = LogFactory.getLog((String)LOGGER_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Publishing event: " + e));
        }
        if ((applicationContext = this.getContext(event.getSession().getServletContext())) != null) {
            applicationContext.publishEvent((ApplicationEvent)e);
        }
    }
}

