/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;

public final class CodeListCacheLoader
implements Callable<Map<String, String>> {
    private final String langCode;
    private final String codeListName;
    private final SchemaManager schemaManager;

    public CodeListCacheLoader(String langCode, String codeListName, SchemaManager schemaManager) {
        this.langCode = langCode;
        this.codeListName = codeListName;
        this.schemaManager = schemaManager;
    }

    public static String cacheKey(String langCode, String codeListName) {
        return "codelist:" + langCode + ":" + codeListName;
    }

    @Override
    public Map<String, String> call() throws Exception {
        HashMap<String, String> _codeList = new HashMap<String, String>();
        Set<String> schemas = this.schemaManager.getSchemas();
        for (String schema : schemas) {
            Path schemaDir = this.schemaManager.getSchemaDir(schema);
            this.addCodeLists(this.codeListName, _codeList, schemaDir.resolve("loc").resolve(this.langCode).resolve("codelists.xml"));
        }
        return _codeList;
    }

    private void addCodeLists(String codeListName, Map<String, String> codeList, Path file) throws IOException, JDOMException {
        if (Files.exists(file, new LinkOption[0])) {
            Element xmlDoc = Xml.loadFile((Path)file);
            List codelists = xmlDoc.getChildren("codelist");
            for (Element element : codelists) {
                if (!element.getAttributeValue("name").equals(codeListName)) continue;
                List entries = element.getChildren("entry");
                for (Element entry : entries) {
                    codeList.put(entry.getChildText("code"), entry.getChildText("label"));
                }
            }
        }
    }
}

