/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.oaipmh.services;

import java.nio.file.Path;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDataInfo;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.oaipmh.Lib;
import org.fao.geonet.kernel.oaipmh.OaiPmhService;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Xml;
import org.fao.oaipmh.exceptions.CannotDisseminateFormatException;
import org.fao.oaipmh.exceptions.IdDoesNotExistException;
import org.fao.oaipmh.requests.AbstractRequest;
import org.fao.oaipmh.requests.GetRecordRequest;
import org.fao.oaipmh.responses.AbstractResponse;
import org.fao.oaipmh.responses.GetRecordResponse;
import org.fao.oaipmh.responses.Header;
import org.fao.oaipmh.responses.Record;
import org.jdom.Attribute;
import org.jdom.Element;
import org.springframework.data.jpa.domain.Specification;

public class GetRecord
implements OaiPmhService {
    public static Record buildRecordStat(ServiceContext context, Specification<Metadata> spec, String prefix) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SchemaManager sm = gc.getBean(SchemaManager.class);
        AbstractMetadata metadata = context.getBean(IMetadataUtils.class).findOne(spec);
        if (metadata == null) {
            throw new IdDoesNotExistException(spec.toString());
        }
        String uuid = metadata.getUuid();
        MetadataDataInfo dataInfo = metadata.getDataInfo();
        String schema = dataInfo.getSchemaId();
        String changeDate = dataInfo.getChangeDate().getDateAndTime();
        String data = metadata.getData();
        Element md = Xml.loadString((String)data, (boolean)false);
        if (prefix.equals(schema)) {
            Attribute schemaLocAtt = sm.getSchemaLocation(schema, context);
            if (schemaLocAtt != null && md.getAttribute(schemaLocAtt.getName(), schemaLocAtt.getNamespace()) == null) {
                md.setAttribute(schemaLocAtt);
                md.removeNamespaceDeclaration(schemaLocAtt.getNamespace());
                md.addNamespaceDeclaration(schemaLocAtt.getNamespace());
            }
        } else {
            Path schemaDir = sm.getSchemaDir(schema);
            if (Lib.existsConverter(schemaDir, prefix)) {
                String siteURL = context.getBean(SettingManager.class).getSiteURL(context);
                Element env = Lib.prepareTransformEnv(uuid, changeDate, context.getBaseUrl(), siteURL, gc.getBean(SettingManager.class).getSiteName());
                md = Lib.transform(schemaDir, env, md, prefix);
            } else {
                List<String> availableConverters = Lib.availableConverters(schemaDir);
                throw new CannotDisseminateFormatException(String.format("Unknown prefix : %s. Available converters are: %s", prefix, availableConverters));
            }
        }
        Header h = new Header();
        h.setIdentifier(uuid);
        h.setDateStamp(new ISODate(changeDate));
        for (MetadataCategory metadataCategory : metadata.getCategories()) {
            h.addSet(metadataCategory.getName());
        }
        Record r = new Record();
        r.setHeader(h);
        r.setMetadata(md);
        return r;
    }

    @Override
    public String getVerb() {
        return "GetRecord";
    }

    @Override
    public AbstractResponse execute(AbstractRequest request, ServiceContext context) throws Exception {
        GetRecordRequest req = (GetRecordRequest)request;
        GetRecordResponse res = new GetRecordResponse();
        String uuid = req.getIdentifier();
        String prefix = req.getMetadataPrefix();
        res.setRecord(this.buildRecord(context, uuid, prefix));
        return res;
    }

    private Record buildRecord(ServiceContext context, String uuid, String prefix) throws Exception {
        return GetRecord.buildRecordStat(context, (Specification<Metadata>)MetadataSpecs.hasMetadataUuid((String)uuid), prefix);
    }
}

