/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.local;

import java.nio.file.Path;
import jeeves.server.JeevesEngine;
import jeeves.server.UserSession;
import jeeves.server.local.LocalServiceRequest;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class LocalJeeves {
    private static JeevesEngine jeeves;
    private static UserSession session;

    public static void main(String[] args) {
        LocalJeeves.init(IO.toPath((String)args[0], (String[])new String[0]), IO.toPath((String)args[1], (String[])new String[0]), args[2]);
        LocalJeeves.exit();
        LocalJeeves.p("ALL OK");
        System.exit(0);
    }

    public static Element dispatch(Element aRequest) {
        return LocalJeeves.dispatch(aRequest.getAttributeValue("url"), (Element)aRequest.getChildren().get(0));
    }

    public static Element dispatch(String anURL, Element params) {
        try {
            LocalJeeves.p("-------- REQUEST -------");
            LocalJeeves.p("url=" + anURL);
            LocalJeeves.p("\n" + Xml.getString((Element)params));
            LocalServiceRequest serviceReq = LocalServiceRequest.create(anURL, params);
            jeeves.dispatch(serviceReq, session);
            if (serviceReq != null) {
                LocalJeeves.p("-------- RESULT -------");
                LocalJeeves.p(serviceReq.getResultString());
                return serviceReq.getResult();
            }
        }
        catch (Throwable t) {
            LocalJeeves.err("Error in service req", t);
        }
        return null;
    }

    public static void exit() {
        try {
            LocalJeeves.p("exit...");
            if (jeeves == null) {
                return;
            }
            jeeves.destroy();
            LocalJeeves.p("exit OK");
        }
        catch (Throwable t) {
            LocalJeeves.err("Cannot exit ", t);
        }
        finally {
            jeeves = null;
        }
    }

    public static boolean isRunning() {
        return jeeves != null;
    }

    public static void init(Path appPath, Path configPath, String baseUrl) {
        try {
            LocalJeeves.p("init...");
            System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
            jeeves = new JeevesEngine();
            jeeves.init(appPath, configPath, baseUrl, null);
            session = new UserSession();
            User user = new User().setProfile(Profile.Administrator).setUsername(Profile.Administrator.name()).setId(0).setName(Profile.Administrator.name()).setSurname(Profile.Administrator.name());
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user.getUsername(), null, user.getAuthorities());
            authentication.setDetails((Object)user);
            if (SecurityContextHolder.getContext() == null) {
                SecurityContextHolder.createEmptyContext();
            }
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    LocalJeeves.exit();
                }
            });
            LocalJeeves.p("init OK");
        }
        catch (Throwable t) {
            LocalJeeves.err("Cannot init ", t);
            jeeves = null;
        }
    }

    private static void p(String s) {
        System.out.println("[LocalJeeves] " + s);
    }

    private static void err(String s, Throwable t) {
        LocalJeeves.p("ERROR: " + s + " msg=" + t.getMessage());
        t.printStackTrace();
    }
}

