/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.AbstractIntegerCodec;
import org.owasp.esapi.codecs.PushbackSequence;

public class JSONCodec
extends AbstractIntegerCodec {
    @Override
    public String encodeCharacter(char[] immune, Character c) {
        if (c == null) {
            return "";
        }
        return this.encodeCharacter(immune, this.charToCodepoint(c));
    }

    @Override
    public String encodeCharacter(char[] immune, int codePoint) throws IllegalArgumentException {
        if (!Character.isValidCodePoint(codePoint)) {
            return "";
        }
        if (immune != null) {
            char[] cArray = immune;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character ch = Character.valueOf(cArray[i]);
                if (this.charToCodepoint(ch) != codePoint) continue;
                return new String(Character.toChars(codePoint));
            }
        }
        switch (codePoint) {
            case 8: {
                return "\\b";
            }
            case 12: {
                return "\\f";
            }
            case 13: {
                return "\\r";
            }
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 34: {
                return "\\\"";
            }
            case 47: {
                return "\\/";
            }
            case 92: {
                return "\\\\";
            }
        }
        if (codePoint <= 31) {
            return String.format("\\u%04x", codePoint);
        }
        return new String(Character.toChars(codePoint));
    }

    @Override
    public Integer decodeCharacter(PushbackSequence<Integer> input) throws IllegalArgumentException {
        input.mark();
        Integer first = input.next();
        Integer second = null;
        if (first == null || first != 92) {
            input.reset();
            return null;
        }
        second = input.next();
        if (second == null) {
            throw new IllegalArgumentException("Invalid JSON escape representation");
        }
        Integer decodedRef = null;
        switch (second) {
            case 98: {
                decodedRef = 8;
                break;
            }
            case 102: {
                decodedRef = 12;
                break;
            }
            case 114: {
                decodedRef = 13;
                break;
            }
            case 110: {
                decodedRef = 10;
                break;
            }
            case 116: {
                decodedRef = 9;
                break;
            }
            case 34: {
                decodedRef = 34;
                break;
            }
            case 47: {
                decodedRef = 47;
                break;
            }
            case 92: {
                decodedRef = 92;
                break;
            }
            case 117: {
                decodedRef = (this.convertToInt(input.next()) << 12) + (this.convertToInt(input.next()) << 8) + (this.convertToInt(input.next()) << 4) + (this.convertToInt(input.next()) << 0);
                break;
            }
            default: {
                input.reset();
                throw new IllegalArgumentException("Invalid JSON two-character escape representation: " + String.format("'%c%c'", Character.valueOf((char)first.intValue()), Character.valueOf((char)second.intValue())));
            }
        }
        return decodedRef;
    }

    protected int charToCodepoint(Character ch) {
        String s = Character.toString(ch.charValue());
        assert (s.length() == 1) : "Ooops";
        return s.codePointAt(0);
    }

    protected int convertToInt(Integer hexDigit) {
        if (hexDigit == null) {
            throw new IllegalArgumentException("Cannot convert from '<null>' to int.");
        }
        int value = Character.digit(hexDigit, 16);
        if (value < 0 || value >= 16) {
            throw new IllegalArgumentException("Cannot convert from hexadecimal '" + hexDigit.toString() + "' to int.");
        }
        return value;
    }
}

