/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jwtheaders.token;

import com.nimbusds.jose.JWSObject;
import org.geoserver.security.jwtheaders.JwtConfiguration;
import org.geoserver.security.jwtheaders.token.TokenAudienceValidator;
import org.geoserver.security.jwtheaders.token.TokenEndpointValidator;
import org.geoserver.security.jwtheaders.token.TokenExpiryValidator;
import org.geoserver.security.jwtheaders.token.TokenSignatureValidator;

public class TokenValidator {
    public JwtConfiguration jwtHeadersConfig;
    public TokenEndpointValidator tokenEndpointValidator;
    public TokenAudienceValidator tokenAudienceValidator;
    public TokenExpiryValidator tokenExpiryValidator;
    public TokenSignatureValidator tokenSignatureValidator;

    public TokenValidator(JwtConfiguration config) {
        this.jwtHeadersConfig = config;
        this.tokenAudienceValidator = new TokenAudienceValidator(this.jwtHeadersConfig);
        this.tokenEndpointValidator = new TokenEndpointValidator(this.jwtHeadersConfig);
        this.tokenExpiryValidator = new TokenExpiryValidator(this.jwtHeadersConfig);
        this.tokenSignatureValidator = new TokenSignatureValidator(this.jwtHeadersConfig);
    }

    public void validate(String accessToken) throws Exception {
        accessToken = accessToken.replaceFirst("^Bearer", "");
        accessToken = accessToken.replaceFirst("^bearer", "");
        accessToken = accessToken.trim();
        if (!this.jwtHeadersConfig.isValidateToken()) {
            return;
        }
        this.validateSignature(accessToken);
        JWSObject jwsToken = JWSObject.parse((String)accessToken);
        this.validateExpiry(jwsToken);
        this.validateEndpoint(accessToken);
        this.validateAudience(jwsToken);
    }

    private void validateAudience(JWSObject accessToken) throws Exception {
        this.tokenAudienceValidator.validate(accessToken);
    }

    private void validateEndpoint(String token) throws Exception {
        this.tokenEndpointValidator.validate(token);
    }

    private void validateExpiry(JWSObject jwsToken) throws Exception {
        this.tokenExpiryValidator.validate(jwsToken);
    }

    private void validateSignature(String accessToken) throws Exception {
        this.tokenSignatureValidator.validate(accessToken);
    }
}

