/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geoPREST;

import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.UUIDMapper;
import org.fao.geonet.kernel.harvest.harvester.geoPREST.GeoPRESTParams;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;

public class Aligner
extends BaseAligner<GeoPRESTParams> {
    private Logger log;
    private ServiceContext context;
    private XmlRequest request;
    private DataManager dataMan;
    private IMetadataManager metadataManager;
    private CategoryMapper localCateg;
    private GroupMapper localGroups;
    private UUIDMapper localUuids;
    private HarvestResult result;

    public Aligner(AtomicBoolean cancelMonitor, Logger log, ServiceContext sc, GeoPRESTParams params) throws Exception {
        super(cancelMonitor);
        this.log = log;
        this.context = sc;
        this.params = params;
        GeonetContext gc = (GeonetContext)this.context.getHandlerContext("contextName");
        this.dataMan = (DataManager)gc.getBean(DataManager.class);
        this.metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        this.result = new HarvestResult();
        this.request = ((GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(new URL(params.baseUrl + "/rest/document"));
    }

    public HarvestResult align(Set<RecordInfo> records, List<HarvestError> errors) throws Exception {
        String id;
        this.log.info("Start of alignment for : " + ((GeoPRESTParams)this.params).getName());
        this.localCateg = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        this.localUuids = new UUIDMapper((IMetadataUtils)this.context.getBean(IMetadataUtils.class), ((GeoPRESTParams)this.params).getUuid());
        this.metadataManager.flush();
        for (String uuid : this.localUuids.getUUIDs()) {
            if (this.cancelMonitor.get()) {
                return this.result;
            }
            if (this.exists(records, uuid)) continue;
            id = this.localUuids.getID(uuid);
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Removing old metadata with local id:" + id);
            }
            this.metadataManager.deleteMetadata(this.context, id);
            this.metadataManager.flush();
            ++this.result.locallyRemoved;
        }
        for (RecordInfo ri : records) {
            if (this.cancelMonitor.get()) {
                return this.result;
            }
            try {
                id = this.dataMan.getMetadataId(ri.uuid);
                if (id == null) {
                    this.addMetadata(ri);
                } else {
                    this.updateMetadata(ri, id);
                }
                ++this.result.totalMetadata;
            }
            catch (Throwable t) {
                errors.add(new HarvestError(this.context, t));
                this.log.error("Unable to process record from csw (" + ((GeoPRESTParams)this.params).getName() + ")");
                this.log.error("   Record failed: " + ri.uuid);
            }
        }
        this.dataMan.forceIndexChanges();
        this.log.info("End of alignment for : " + ((GeoPRESTParams)this.params).getName());
        return this.result;
    }

    private void addMetadata(RecordInfo ri) throws Exception {
        Element md = this.retrieveMetadata(ri.uuid);
        if (md == null) {
            return;
        }
        String schema = this.dataMan.autodetectSchema(md, null);
        if (schema == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Metadata skipped due to unknown schema. uuid:" + ri.uuid);
            }
            ++this.result.unknownSchema;
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("  - Adding metadata with remote uuid:" + ri.uuid + " schema:" + schema);
        }
        int userid = 1;
        Metadata metadata = new Metadata();
        metadata.setUuid(ri.uuid);
        metadata.getDataInfo().setSchemaId(schema).setRoot(md.getQualifiedName()).setType(MetadataType.METADATA).setChangeDate(new ISODate(ri.changeDate)).setCreateDate(new ISODate(ri.changeDate));
        metadata.getSourceInfo().setSourceId(((GeoPRESTParams)this.params).getUuid()).setOwner(Integer.valueOf(userid));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((GeoPRESTParams)this.params).getUuid());
        this.addCategories((AbstractMetadata)metadata, ((GeoPRESTParams)this.params).getCategories(), this.localCateg, this.context, null, false);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, IndexingMode.none, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        this.addPrivileges(id, ((GeoPRESTParams)this.params).getPrivileges(), this.localGroups, this.context);
        this.dataMan.indexMetadata(id, Math.random() < 0.01);
        ++this.result.addedMetadata;
    }

    private void updateMetadata(RecordInfo ri, String id) throws Exception {
        String date = this.localUuids.getChangeDate(ri.uuid);
        if (date == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Skipped metadata managed by another harvesting node. uuid:" + ri.uuid + ", name:" + ((GeoPRESTParams)this.params).getName());
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Comparing date " + date + " with harvested date " + ri.changeDate + " Comparison: " + ri.isMoreRecentThan(date));
            }
            if (!ri.isMoreRecentThan(date)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  - Metadata XML not changed for uuid:" + ri.uuid);
                }
                ++this.result.unchangedMetadata;
            } else {
                Element md;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  - Updating local metadata for uuid:" + ri.uuid);
                }
                if ((md = this.retrieveMetadata(ri.uuid)) == null) {
                    return;
                }
                boolean validate = false;
                boolean ufo = false;
                String language = this.context.getLanguage();
                AbstractMetadata metadata = this.metadataManager.updateMetadata(this.context, id, md, validate, ufo, language, ri.changeDate, false, IndexingMode.none);
                OperationAllowedRepository repository = (OperationAllowedRepository)this.context.getBean(OperationAllowedRepository.class);
                repository.deleteAllByMetadataId(Integer.parseInt(id));
                this.addPrivileges(id, ((GeoPRESTParams)this.params).getPrivileges(), this.localGroups, this.context);
                metadata.getCategories().clear();
                this.addCategories(metadata, ((GeoPRESTParams)this.params).getCategories(), this.localCateg, this.context, null, true);
                this.metadataManager.flush();
                this.dataMan.indexMetadata(id, Math.random() < 0.01);
                ++this.result.updatedMetadata;
            }
        }
    }

    private boolean exists(Set<RecordInfo> records, String uuid) {
        for (RecordInfo ri : records) {
            if (!uuid.equals(ri.uuid)) continue;
            return true;
        }
        return false;
    }

    private Element retrieveMetadata(String uuid) {
        this.request.clearParams();
        this.request.addParam("id", (Object)uuid);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Getting record from : " + this.request.getHost() + " (uuid:" + uuid + ")");
            }
            Element response = null;
            try {
                response = this.request.execute();
            }
            catch (Exception e) {
                this.log.error("Getting record from GeoPortal REST raised exception: " + e.getMessage());
                this.log.error("Sent request " + this.request.getSentData());
                this.log.error((Throwable)e);
                throw new Exception(e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Record got:\n" + Xml.getString((Element)response));
            }
            try {
                Integer groupIdVal = null;
                if (StringUtils.isNotEmpty((String)((GeoPRESTParams)this.params).getOwnerIdGroup())) {
                    groupIdVal = this.getGroupOwner();
                }
                ((GeoPRESTParams)this.params).getValidate().validate(this.dataMan, this.context, response, groupIdVal);
            }
            catch (Exception e) {
                this.log.info("Ignoring invalid metadata with uuid " + uuid);
                ++this.result.doesNotValidate;
                return null;
            }
            if (!((GeoPRESTParams)this.params).getImportXslt().equals("none")) {
                Path thisXslt = ((GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class)).getXsltConversion(((GeoPRESTParams)this.params).getImportXslt());
                try {
                    response = Xml.transform((Element)response, (Path)thisXslt);
                }
                catch (Exception e) {
                    this.log.info("Cannot transform XML " + Xml.getString((Element)response) + ", ignoring. Error was: " + e.getMessage());
                    ++this.result.badFormat;
                    return null;
                }
            }
            return response;
        }
        catch (Exception e) {
            this.log.warning("Raised exception while getting record : " + e);
            this.log.error((Throwable)e);
            ++this.result.unretrievable;
            return null;
        }
    }
}

