/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest;

import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.harvest.AbstractAligner;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.Privileges;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class BaseAligner<P extends AbstractParams>
extends AbstractAligner<P> {
    private static org.slf4j.Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.harvester");
    public final AtomicBoolean cancelMonitor;

    protected BaseAligner(AtomicBoolean cancelMonitor) {
        this.cancelMonitor = cancelMonitor;
    }

    public void addCategories(AbstractMetadata metadata, Iterable<String> categories, CategoryMapper localCateg, ServiceContext context, String serverCategory, boolean saveMetadata) {
        MetadataCategoryRepository metadataCategoryRepository = (MetadataCategoryRepository)context.getBean(MetadataCategoryRepository.class);
        HashMap<CallSite, MetadataCategory> nameToCategoryMap = new HashMap<CallSite, MetadataCategory>();
        for (MetadataCategory metadataCategory : metadataCategoryRepository.findAll()) {
            nameToCategoryMap.put((CallSite)((Object)("" + metadataCategory.getId())), metadataCategory);
        }
        for (String catId : categories) {
            String name = localCateg.getName(catId);
            if (name == null) {
                LOGGER.debug("    - Skipping removed category with id:{}", (Object)catId);
                continue;
            }
            LOGGER.debug("    - Setting category : {}", (Object)name);
            MetadataCategory metadataCategory = (MetadataCategory)nameToCategoryMap.get(catId);
            if (metadataCategory != null) {
                metadata.getCategories().add(metadataCategory);
                continue;
            }
            LOGGER.warn("Unable to map category: {} ({}) to a category in Geonetwork", (Object)catId, (Object)name);
        }
        if (serverCategory != null) {
            String catId = localCateg.getID(serverCategory);
            if (catId == null) {
                LOGGER.debug("    - Skipping removed category :{}", (Object)serverCategory);
            } else {
                MetadataCategory metadataCategory;
                metadataCategory = (MetadataCategory)nameToCategoryMap.get(catId);
                if (metadataCategory != null) {
                    metadata.getCategories().add(metadataCategory);
                } else {
                    LOGGER.warn("Unable to map category: {} to a category in Geonetwork", (Object)catId);
                }
            }
        }
        if (saveMetadata) {
            ((IMetadataManager)context.getBean(IMetadataManager.class)).save(metadata);
        }
    }

    public void addPrivileges(String id, Iterable<Privileges> privilegesIterable, GroupMapper localGroups, ServiceContext context) throws Exception {
        OperationAllowedRepository operationAllowedRepository = (OperationAllowedRepository)context.getBean(OperationAllowedRepository.class);
        DataManager dataManager = (DataManager)context.getBean(DataManager.class);
        if (!this.params.isIfRecordExistAppendPrivileges()) {
            operationAllowedRepository.deleteAllByMetadataId(Integer.parseInt(id));
        }
        for (Privileges priv : privilegesIterable) {
            String name = localGroups.getName(priv.getGroupId());
            if (name == null) {
                LOGGER.debug("    - Skipping removed group with id: {}", (Object)priv.getGroupId());
                continue;
            }
            LOGGER.debug("    - Setting privileges for group: {}", (Object)name);
            for (int opId : priv.getOperations()) {
                name = dataManager.getAccessManager().getPrivilegeName(opId);
                if (name == null) continue;
                LOGGER.debug("       --> Operation: {}", (Object)name);
                dataManager.setOperation(context, id, priv.getGroupId(), "" + opId);
            }
        }
    }

    public Element translateMetadataContent(ServiceContext context, Element md, String schema) {
        SettingManager settingManager = (SettingManager)context.getBean(SettingManager.class);
        String translationProvider = settingManager.getValue("system/translation/provider");
        if (!StringUtils.hasLength((String)translationProvider)) {
            LOGGER.warn("     metadata content can't be translated. Translation provider not configured.");
            return md;
        }
        if (!StringUtils.hasLength((String)this.params.getTranslateContentLangs()) || !StringUtils.hasLength((String)this.params.getTranslateContentFields())) {
            LOGGER.warn("     metadata content can't be translated. No languages or fields provided to translate.");
            return md;
        }
        SchemaManager schemaManager = (SchemaManager)context.getBean(SchemaManager.class);
        Path filePath = schemaManager.getSchemaDir(schema).resolve("process").resolve("translate.xsl");
        if (!Files.exists(filePath, new LinkOption[0])) {
            LOGGER.debug(String.format("     metadata content translation process not available for schema %s", schema));
        } else {
            try {
                HashMap<String, List<String>> processParams = new HashMap<String, List<String>>();
                List<String> langs = Arrays.asList(this.params.getTranslateContentLangs().split(","));
                processParams.put("languages", langs);
                List<String> fields = Arrays.asList(this.params.getTranslateContentFields().split("\\n"));
                processParams.put("fieldsToTranslate", fields);
                Element processedMetadata = Xml.transform((Element)md, (Path)filePath, processParams);
                LOGGER.debug("     metadata content translated.");
                md = processedMetadata;
            }
            catch (Exception e) {
                LOGGER.warn(String.format("     metadata content translated error: %s", e.getMessage()));
            }
        }
        return md;
    }

    protected Element applyXSLTProcessToMetadata(ServiceContext context, Element md, String processName, Map<String, Object> processParams, Logger log) {
        Path filePath = ((GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class)).getXsltConversion(processName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            log.debug("     processing instruction  " + processName + ". Metadata not filtered.");
        } else {
            try {
                Element processedMetadata = Xml.transform((Element)md, (Path)filePath, processParams);
                log.debug("     metadata filtered.");
                md = processedMetadata;
            }
            catch (Exception e) {
                log.warning("     processing error " + processName + ": " + e.getMessage());
            }
        }
        return md;
    }
}

