/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.extensions.processor.support.template.AbstractJsTemplateCompiler;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.Destroyable;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

public abstract class JsTemplateCompilerProcessor
implements ResourcePreProcessor,
Destroyable {
    private final ObjectPoolHelper<AbstractJsTemplateCompiler> enginePool = new ObjectPoolHelper<AbstractJsTemplateCompiler>(new ObjectFactory<AbstractJsTemplateCompiler>(){

        public AbstractJsTemplateCompiler create() {
            return JsTemplateCompilerProcessor.this.createCompiler();
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        AbstractJsTemplateCompiler jsCompiler = this.enginePool.getObject();
        try {
            writer.write(jsCompiler.compile(content, this.getArgument(resource)));
        }
        finally {
            this.enginePool.returnObject(jsCompiler);
            reader.close();
            writer.close();
        }
    }

    protected String getArgument(Resource resource) {
        return resource == null ? "" : FilenameUtils.getBaseName((String)resource.getUri());
    }

    protected abstract AbstractJsTemplateCompiler createCompiler();

    public void destroy() throws Exception {
        this.enginePool.destroy();
    }
}

