/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.turtle;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.NamespaceListener;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParseException;
import org.openrdf.rio.ParseLocationListener;
import org.openrdf.rio.Parser;
import org.openrdf.rio.StatementHandler;
import org.openrdf.rio.StatementHandlerException;
import org.openrdf.rio.turtle.TurtleUtil;
import org.openrdf.util.ASCIIUtil;
import org.openrdf.util.uri.URI;
import org.openrdf.util.xml.XmlDatatypeUtil;

public class TurtleParser
implements Parser {
    private StatementHandler _statementHandler;
    private NamespaceListener _nsListener;
    private ParseErrorListener _errListener;
    private ParseLocationListener _locListener;
    private URI _baseURI;
    private LineNumberReader _lineReader;
    private PushbackReader _reader;
    private ValueFactory _valFactory;
    private Map _bNodeIdMap;
    private Map _namespaceTable;
    private Resource _subject;
    private org.openrdf.model.URI _predicate;
    private Value _object;
    boolean _verifyData = true;
    boolean _preserveBNodeIds = false;
    private int _datatypeHandling;

    public TurtleParser() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    public TurtleParser(ValueFactory valueFactory) {
        this._valFactory = valueFactory;
        this._bNodeIdMap = new HashMap();
        this._datatypeHandling = 20;
        this._namespaceTable = new HashMap(16);
    }

    public synchronized void setStatementHandler(StatementHandler sh) {
        this._statementHandler = sh;
    }

    public void setNamespaceListener(NamespaceListener nl) {
        this._nsListener = nl;
    }

    public synchronized void setParseErrorListener(ParseErrorListener el) {
        this._errListener = el;
    }

    public synchronized void setParseLocationListener(ParseLocationListener el) {
        this._locListener = el;
    }

    public synchronized void setVerifyData(boolean verifyData) {
        this._verifyData = verifyData;
    }

    public void setPreserveBNodeIds(boolean preserveBNodeIds) {
        this._preserveBNodeIds = preserveBNodeIds;
    }

    public synchronized void setStopAtFirstError(boolean stopAtFirstError) {
    }

    public void setDatatypeHandling(int datatypeHandling) {
        this._datatypeHandling = datatypeHandling;
    }

    public synchronized void parse(InputStream in, String baseURI) throws IOException, ParseException, StatementHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream can not be 'null'");
        }
        try {
            this.parse(new InputStreamReader(in, "UTF-8"), baseURI);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(Reader reader, String baseURI) throws IOException, ParseException, StatementHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader can not be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("base URI can not be 'null'");
        }
        this._lineReader = new LineNumberReader(reader);
        this._lineReader.setLineNumber(1);
        this._reader = new PushbackReader(this._lineReader, 2);
        this._baseURI = new URI(baseURI);
        this._baseURI.normalize();
        this._reportLocation();
        try {
            int c;
            while ((c = this._skipWSC()) != -1) {
                if (c == 64) {
                    this._parsePrefix();
                    continue;
                }
                this._parseTriple();
            }
        }
        finally {
            this._bNodeIdMap.clear();
            this._namespaceTable.clear();
        }
    }

    private void _parsePrefix() throws IOException, ParseException {
        this._verifyCharacter(this._read(), "@");
        this._verifyCharacter(this._read(), "p");
        this._verifyCharacter(this._read(), "r");
        this._verifyCharacter(this._read(), "e");
        this._verifyCharacter(this._read(), "f");
        this._verifyCharacter(this._read(), "i");
        this._verifyCharacter(this._read(), "x");
        this._skipWSC();
        StringBuffer prefixID = new StringBuffer(8);
        while (true) {
            int c;
            if ((c = this._read()) == 58) break;
            if (c == -1) {
                this._throwEOFException();
            }
            prefixID.append((char)c);
        }
        this._read();
        this._skipWSC();
        org.openrdf.model.URI namespace = this._parseUriRef();
        this._skipWSC();
        this._verifyCharacter(this._read(), ".");
        String prefixStr = prefixID.toString();
        String namespaceStr = namespace.getURI();
        this._namespaceTable.put(prefixStr, namespaceStr);
        if (this._nsListener != null) {
            this._nsListener.handleNamespace(prefixStr, namespaceStr);
        }
    }

    private void _parseTriple() throws IOException, ParseException, StatementHandlerException {
        this._parseSubject();
        this._skipWSC();
        this._parsePredicateObjectList();
        this._skipWSC();
        this._verifyCharacter(this._read(), ".");
        this._subject = null;
        this._predicate = null;
        this._object = null;
    }

    private void _parsePredicateObjectList() throws IOException, ParseException, StatementHandlerException {
        this._predicate = this._parsePredicate();
        this._skipWSC();
        this._parseObjectList();
        while (this._skipWSC() == 59) {
            this._read();
            int c = this._skipWSC();
            if (c == 46 || c == 93) break;
            this._predicate = this._parsePredicate();
            this._skipWSC();
            this._parseObjectList();
        }
    }

    private void _parseObjectList() throws IOException, ParseException, StatementHandlerException {
        this._parseObject();
        while (this._skipWSC() == 44) {
            this._read();
            this._skipWSC();
            this._parseObject();
        }
    }

    private void _parseSubject() throws IOException, ParseException, StatementHandlerException {
        int c = this._peek();
        if (c == 40) {
            this._subject = this._parseCollection();
        } else if (c == 91) {
            this._subject = this._parseImplicitBlank();
        } else {
            Value value = this._parseValue();
            if (value instanceof Resource) {
                this._subject = (Resource)value;
            } else {
                this._throwParseException("Illegal subject value: " + value);
            }
        }
    }

    private org.openrdf.model.URI _parsePredicate() throws IOException, ParseException {
        int c1 = this._read();
        if (c1 == 97) {
            int c2 = this._read();
            if (TurtleUtil.isWhitespace(c2)) {
                return this._createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
            }
            this._unread(c2);
        }
        this._unread(c1);
        Value predicate = this._parseValue();
        if (predicate instanceof org.openrdf.model.URI) {
            return (org.openrdf.model.URI)predicate;
        }
        this._throwParseException("Illegal predicate value: " + predicate);
        return null;
    }

    private void _parseObject() throws IOException, ParseException, StatementHandlerException {
        int c = this._peek();
        this._object = c == 40 ? this._parseCollection() : (c == 91 ? this._parseImplicitBlank() : this._parseValue());
        this._statementHandler.handleStatement(this._subject, this._predicate, this._object);
    }

    private Resource _parseCollection() throws IOException, ParseException, StatementHandlerException {
        this._verifyCharacter(this._read(), "(");
        int c = this._skipWSC();
        if (c == 41) {
            this._read();
            return this._createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        }
        BNode listRoot = this._createBNode();
        Resource oldSubject = this._subject;
        org.openrdf.model.URI oldPredicate = this._predicate;
        org.openrdf.model.URI rdfFirst = this._createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        org.openrdf.model.URI rdfRest = this._createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        org.openrdf.model.URI rdfNil = this._createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        this._subject = listRoot;
        this._predicate = rdfFirst;
        this._parseObject();
        BNode bNode = listRoot;
        while (this._skipWSC() != 41) {
            BNode newNode = this._createBNode();
            this._statementHandler.handleStatement((Resource)bNode, rdfRest, (Value)newNode);
            bNode = newNode;
            this._subject = bNode;
            this._parseObject();
        }
        this._read();
        this._statementHandler.handleStatement((Resource)bNode, rdfRest, (Value)rdfNil);
        this._subject = oldSubject;
        this._predicate = oldPredicate;
        return listRoot;
    }

    private Resource _parseImplicitBlank() throws IOException, ParseException, StatementHandlerException {
        this._verifyCharacter(this._read(), "[");
        BNode bNode = this._createBNode();
        int c = this._read();
        if (c != 93) {
            Resource oldSubject = this._subject;
            org.openrdf.model.URI oldPredicate = this._predicate;
            this._subject = bNode;
            this._skipWSC();
            this._parsePredicateObjectList();
            this._skipWSC();
            this._verifyCharacter(this._read(), "]");
            this._subject = oldSubject;
            this._predicate = oldPredicate;
        }
        return bNode;
    }

    private Value _parseValue() throws IOException, ParseException {
        int c = this._peek();
        if (c == 60) {
            return this._parseUriRef();
        }
        if (c == 58 || TurtleUtil.isPrefixStartChar(c)) {
            return this._parseQNameOrBoolean();
        }
        if (c == 95) {
            return this._parseNodeID();
        }
        if (c == 34) {
            return this._parseQuotedLiteral();
        }
        if (ASCIIUtil.isNumber((int)c) || c == 46 || c == 43 || c == 45) {
            return this._parseNumber();
        }
        if (c == -1) {
            this._throwEOFException();
            return null;
        }
        this._throwParseException("Expected an RDF value here, found '" + (char)c + "'");
        return null;
    }

    private Literal _parseQuotedLiteral() throws IOException, ParseException {
        String label = this._parseQuotedString();
        int c = this._peek();
        if (c == 64) {
            this._read();
            StringBuffer lang = new StringBuffer(8);
            c = this._read();
            if (c == -1) {
                this._throwEOFException();
            }
            if (!TurtleUtil.isLanguageStartChar(c)) {
                this._throwParseException("Expected a letter, found '" + (char)c + "'");
            }
            lang.append((char)c);
            c = this._read();
            while (TurtleUtil.isLanguageChar(c)) {
                lang.append((char)c);
                c = this._read();
            }
            this._unread(c);
            return this._createLiteral(label, lang.toString(), null);
        }
        if (c == 94) {
            this._read();
            this._verifyCharacter(this._read(), "^");
            Value datatype = this._parseValue();
            if (datatype instanceof org.openrdf.model.URI) {
                return this._createLiteral(label, null, (org.openrdf.model.URI)datatype);
            }
            this._throwParseException("Illegal datatype value: " + datatype);
            return null;
        }
        return this._createLiteral(label, null, null);
    }

    private String _parseQuotedString() throws IOException, ParseException {
        String result = null;
        this._verifyCharacter(this._read(), "\"");
        int c2 = this._read();
        int c3 = this._read();
        if (c2 == 34 && c3 == 34) {
            result = this._parseLongString();
        } else {
            this._unread(c3);
            this._unread(c2);
            result = this._parseString();
        }
        try {
            result = TurtleUtil.decodeString(result);
        }
        catch (IllegalArgumentException e) {
            this._throwParseException(e.getMessage());
        }
        return result;
    }

    private String _parseString() throws IOException, ParseException {
        int c;
        StringBuffer stringBuf = new StringBuffer(32);
        while ((c = this._read()) != 34) {
            if (c == -1) {
                this._throwEOFException();
            }
            stringBuf.append((char)c);
            if (c != 92) continue;
            c = this._read();
            if (c == -1) {
                this._throwEOFException();
            }
            stringBuf.append((char)c);
        }
        return stringBuf.toString();
    }

    private String _parseLongString() throws IOException, ParseException {
        StringBuffer stringBuf = new StringBuffer(1024);
        int doubleQuoteCount = 0;
        while (doubleQuoteCount < 3) {
            int c = this._read();
            if (c == -1) {
                this._throwEOFException();
            } else {
                doubleQuoteCount = c == 34 ? ++doubleQuoteCount : 0;
            }
            stringBuf.append((char)c);
            if (c != 92) continue;
            c = this._read();
            if (c == -1) {
                this._throwEOFException();
            }
            stringBuf.append((char)c);
        }
        return stringBuf.substring(0, stringBuf.length() - 3);
    }

    private Literal _parseNumber() throws IOException, ParseException {
        StringBuffer value = new StringBuffer(8);
        String datatype = "http://www.w3.org/2001/XMLSchema#integer";
        int c = this._read();
        if (c == 43 || c == 45) {
            value.append((char)c);
            c = this._read();
        }
        while (ASCIIUtil.isNumber((int)c)) {
            value.append((char)c);
            c = this._read();
        }
        if (c == 46 || c == 101 || c == 69) {
            datatype = "http://www.w3.org/2001/XMLSchema#decimal";
            if (c == 46) {
                value.append((char)c);
                c = this._read();
                while (ASCIIUtil.isNumber((int)c)) {
                    value.append((char)c);
                    c = this._read();
                }
                if (value.length() == 1) {
                    this._throwParseException("Object for statement missing");
                }
            } else if (value.length() == 0) {
                this._throwParseException("Object for statement missing");
            }
            if (c == 101 || c == 69) {
                datatype = "http://www.w3.org/2001/XMLSchema#double";
                value.append((char)c);
                c = this._read();
                if (c == 43 || c == 45) {
                    value.append((char)c);
                    c = this._read();
                }
                if (!ASCIIUtil.isNumber((int)c)) {
                    this._throwParseException("Exponent value missing");
                }
                value.append((char)c);
                c = this._read();
                while (ASCIIUtil.isNumber((int)c)) {
                    value.append((char)c);
                    c = this._read();
                }
            }
        }
        this._unread(c);
        org.openrdf.model.URI dtURI = this._createURI(datatype);
        return this._createLiteral(value.toString(), null, dtURI);
    }

    private org.openrdf.model.URI _parseUriRef() throws IOException, ParseException {
        StringBuffer uriRef = new StringBuffer(100);
        int c = this._read();
        this._verifyCharacter(c, "<");
        while ((c = this._read()) != 62) {
            if (c == -1) {
                this._throwEOFException();
            }
            uriRef.append((char)c);
            if (c != 92) continue;
            c = this._read();
            if (c == -1) {
                this._throwEOFException();
            }
            uriRef.append((char)c);
        }
        String uri = null;
        try {
            uri = TurtleUtil.decodeString(uriRef.toString());
        }
        catch (IllegalArgumentException e) {
            this._throwParseException(e.getMessage());
        }
        URI relUri = new URI(uri);
        if (this._verifyData && relUri.isRelative() && !relUri.isSelfReference() && this._baseURI.isOpaque()) {
            this._throwParseException("Relative URI '" + uri + "' cannot be resolved using the opaque base URI '" + this._baseURI + "'");
        }
        uri = this._baseURI.resolve(relUri).toString();
        return this._createURI(uri);
    }

    private Value _parseQNameOrBoolean() throws IOException, ParseException {
        int c = this._read();
        if (c == -1) {
            this._throwEOFException();
        }
        if (c != 58 && !TurtleUtil.isPrefixStartChar(c)) {
            this._throwParseException("Expected a ':' or a letter, found '" + (char)c + "'");
        }
        String namespace = null;
        if (c == 58) {
            namespace = (String)this._namespaceTable.get("");
            if (namespace == null) {
                this._throwParseException("Default namespace used but not defined");
            }
        } else {
            String value;
            StringBuffer prefix = new StringBuffer(8);
            prefix.append((char)c);
            c = this._read();
            while (TurtleUtil.isPrefixChar(c)) {
                prefix.append((char)c);
                c = this._read();
            }
            if (c != 58 && ((value = prefix.toString()).equals("true") || value.equals("false"))) {
                org.openrdf.model.URI dtURI = this._createURI("http://www.w3.org/2001/XMLSchema#boolean");
                return this._createLiteral(value, null, dtURI);
            }
            this._verifyCharacter(c, ":");
            namespace = (String)this._namespaceTable.get(prefix.toString());
            if (namespace == null) {
                this._throwParseException("Namespace prefix '" + prefix.toString() + "' used but not defined");
            }
        }
        StringBuffer localName = new StringBuffer(16);
        c = this._read();
        if (TurtleUtil.isNameStartChar(c)) {
            localName.append((char)c);
            c = this._read();
            while (TurtleUtil.isNameChar(c)) {
                localName.append((char)c);
                c = this._read();
            }
        }
        this._unread(c);
        return this._createURI(namespace + localName.toString());
    }

    private BNode _parseNodeID() throws IOException, ParseException {
        this._verifyCharacter(this._read(), "_");
        this._verifyCharacter(this._read(), ":");
        int c = this._read();
        if (c == -1) {
            this._throwEOFException();
        } else if (!TurtleUtil.isNameStartChar(c)) {
            this._throwParseException("Expected a letter, found '" + (char)c + "'");
        }
        StringBuffer name = new StringBuffer(32);
        name.append((char)c);
        c = this._read();
        while (TurtleUtil.isNameChar(c)) {
            name.append((char)c);
            c = this._read();
        }
        this._unread(c);
        return this._createBNode(name.toString());
    }

    private org.openrdf.model.URI _createURI(String uri) throws ParseException {
        try {
            return this._valFactory.createURI(uri);
        }
        catch (Exception e) {
            this._throwParseException(e);
            return null;
        }
    }

    private BNode _createBNode() throws ParseException {
        try {
            return this._valFactory.createBNode();
        }
        catch (Exception e) {
            this._throwParseException(e);
            return null;
        }
    }

    private BNode _createBNode(String nodeID) throws ParseException {
        BNode result = (BNode)this._bNodeIdMap.get(nodeID);
        if (result == null) {
            try {
                result = this._preserveBNodeIds ? this._valFactory.createBNode(nodeID) : this._valFactory.createBNode();
            }
            catch (Exception e) {
                this._throwParseException(e);
            }
            this._bNodeIdMap.put(nodeID, result);
        }
        return result;
    }

    private Literal _createLiteral(String label, String lang, org.openrdf.model.URI datatype) throws ParseException {
        if (datatype != null) {
            if (this._datatypeHandling == 20) {
                if (!XmlDatatypeUtil.isValidValue((String)label, (String)datatype.getURI())) {
                    this._throwParseException("'" + label + "' is not a valid value for datatype " + datatype);
                }
            } else if (this._datatypeHandling == 30) {
                try {
                    label = XmlDatatypeUtil.normalize((String)label, (String)datatype.getURI());
                }
                catch (IllegalArgumentException e) {
                    this._throwParseException("'" + label + "' is not a valid value for datatype " + datatype + ": " + e.getMessage());
                }
            }
        }
        try {
            if (datatype != null) {
                return this._valFactory.createLiteral(label, datatype);
            }
            if (lang != null) {
                return this._valFactory.createLiteral(label, lang);
            }
            return this._valFactory.createLiteral(label);
        }
        catch (Exception e) {
            this._throwParseException(e);
            return null;
        }
    }

    private void _verifyCharacter(int c, String expected) throws ParseException {
        if (c == -1) {
            this._throwEOFException();
        } else if (expected.indexOf((char)c) == -1) {
            StringBuffer msg = new StringBuffer(32);
            msg.append("Expected ");
            for (int i = 0; i < expected.length(); ++i) {
                if (i > 0) {
                    msg.append(" or ");
                }
                msg.append('\'');
                msg.append(expected.charAt(i));
                msg.append('\'');
            }
            msg.append(", found '");
            msg.append((char)c);
            msg.append("'");
            this._throwParseException(msg.toString());
        }
    }

    private int _skipWSC() throws IOException {
        int c = this._read();
        while (TurtleUtil.isWhitespace(c) || c == 35) {
            if (c == 35) {
                this._skipLine();
            }
            c = this._read();
        }
        this._unread(c);
        return c;
    }

    private void _skipLine() throws IOException {
        int c = this._read();
        while (c != -1 && c != 13 && c != 10) {
            c = this._read();
        }
        if (c == 13 && (c = this._read()) != 10) {
            this._unread(c);
        }
        this._reportLocation();
    }

    private int _read() throws IOException {
        return this._reader.read();
    }

    private void _unread(int c) throws IOException {
        if (c != -1) {
            this._reader.unread(c);
        }
    }

    private int _peek() throws IOException {
        int result = this._read();
        this._unread(result);
        return result;
    }

    private void _reportLocation() {
        if (this._locListener != null) {
            this._locListener.parseLocationUpdate(this._lineReader.getLineNumber(), -1);
        }
    }

    private void _throwParseException(String msg) throws ParseException {
        if (this._errListener != null) {
            this._errListener.fatalError(msg, this._lineReader.getLineNumber(), -1);
        }
        throw new ParseException(msg, this._lineReader.getLineNumber(), -1);
    }

    private void _throwParseException(Exception e) throws ParseException {
        if (e instanceof ParseException) {
            throw (ParseException)e;
        }
        if (this._errListener != null) {
            this._errListener.fatalError(e.getMessage(), this._lineReader.getLineNumber(), -1);
        }
        throw new ParseException(e, this._lineReader.getLineNumber(), -1);
    }

    private void _throwEOFException() throws ParseException {
        this._throwParseException("Unexpected end of file");
    }
}

