/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.health;

import com.yammer.metrics.core.HealthCheck;
import java.util.List;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.HarvestHistory;
import org.fao.geonet.domain.HarvestHistory_;
import org.fao.geonet.domain.HarvesterSetting;
import org.fao.geonet.kernel.harvest.Common;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.repository.HarvestHistoryRepository;
import org.fao.geonet.repository.HarvesterSettingRepository;
import org.fao.geonet.repository.specification.HarvestHistorySpecs;
import org.jdom.Element;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public class HarvestersHealthCheck
implements HealthCheckFactory {
    public HealthCheck create(final ServiceContext context) {
        return new HealthCheck(this.getClass().getSimpleName()){

            protected HealthCheck.Result check() throws Exception {
                HarvesterSettingRepository repository = (HarvesterSettingRepository)context.getBean(HarvesterSettingRepository.class);
                HarvestManager harvestManager = (HarvestManager)context.getBean(HarvestManager.class);
                HarvestHistoryRepository historyRepository = (HarvestHistoryRepository)context.getBean(HarvestHistoryRepository.class);
                StringBuilder errors = new StringBuilder();
                List nodes = repository.findAllByPath("harvesting/node/site/uuid");
                for (HarvesterSetting node : nodes) {
                    HarvestHistory harvestHistory;
                    PageRequest pageRequest;
                    Specification spec;
                    Page historyPage;
                    String harvestUuid = node.getValue();
                    AbstractHarvester harvester = harvestManager.getHarvester(harvestUuid);
                    if (harvester.getStatus() != Common.Status.ACTIVE || (historyPage = historyRepository.findAll(spec = HarvestHistorySpecs.hasHarvesterUuid((String)harvestUuid), (Pageable)(pageRequest = PageRequest.of((int)0, (int)1, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{HarvestHistory_.harvestDate.getName()})))).getContent().isEmpty() || (harvestHistory = (HarvestHistory)historyPage.getContent().get(0)) == null || harvestHistory.getInfoAsXml() == null || harvestHistory.getInfoAsXml().getChild("stack") == null) continue;
                    Element stack = harvestHistory.getInfoAsXml().getChild("stack");
                    Element errorMsg = stack.getChild("message");
                    errors.append("\n  * ");
                    errors.append(harvester.getParams().getName()).append(" (").append(harvester.getType()).append(")");
                    errors.append(": ").append(errorMsg);
                }
                if (errors.length() == 0) {
                    return HealthCheck.Result.healthy();
                }
                return HealthCheck.Result.unhealthy((String)("The following harvesters has errors during their last harvest:" + errors));
            }
        };
    }
}

