/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.util.Locale;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.nativeaccess.lib.SystemdLibrary;

public class Systemd {
    private static final Logger logger = LogManager.getLogger(Systemd.class);
    private final SystemdLibrary lib;

    Systemd(SystemdLibrary lib) {
        this.lib = lib;
    }

    public void notify_ready() {
        this.notify("READY=1", false);
    }

    public void notify_extend_timeout(long seconds) {
        this.notify("EXTEND_TIMEOUT_USEC=" + seconds * 1000000L, true);
    }

    public void notify_stopping() {
        this.notify("STOPPING=1", true);
    }

    private void notify(String state, boolean warnOnError) {
        int rc = this.lib.sd_notify(0, state);
        logger.trace("sd_notify({}, {}) returned [{}]", new Object[]{0, state, rc});
        if (rc < 0) {
            String message = String.format(Locale.ROOT, "sd_notify(%d, %s) returned error [%d]", 0, state, rc);
            if (warnOnError) {
                logger.warn(message);
            } else {
                throw new RuntimeException(message);
            }
        }
    }
}

