/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.entitylistener;

import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.HarvesterSetting;
import org.fao.geonet.entitylistener.GeonetworkEntityListener;
import org.fao.geonet.entitylistener.PersistentEventType;
import org.fao.geonet.utils.Log;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.springframework.beans.factory.annotation.Autowired;

public class HarvesterSettingValueSetter
implements GeonetworkEntityListener<HarvesterSetting> {
    protected Logger log = Log.createLogger((String)"geonetwork.domain");
    @Autowired
    private StandardPBEStringEncryptor encryptor;

    @Override
    public Class<HarvesterSetting> getEntityClass() {
        return HarvesterSetting.class;
    }

    @Override
    public void handleEvent(PersistentEventType type, HarvesterSetting entity) {
        try {
            if (type == PersistentEventType.PrePersist) {
                if (entity.isEncrypted() && StringUtils.isNotEmpty((String)entity.getValue())) {
                    entity.setStoredValue(this.encryptor.encrypt(entity.getValue()));
                } else {
                    entity.setStoredValue(entity.getValue());
                }
            } else if (type == PersistentEventType.PreUpdate) {
                if (entity.isEncrypted() && StringUtils.isNotEmpty((String)entity.getValue())) {
                    entity.setStoredValue(this.encryptor.encrypt(entity.getValue()));
                }
            } else if (type == PersistentEventType.PostLoad || type == PersistentEventType.PostUpdate) {
                if (entity.isEncrypted() && StringUtils.isNotEmpty((String)entity.getStoredValue())) {
                    entity.setValue(this.encryptor.decrypt(entity.getStoredValue()));
                } else {
                    entity.setValue(entity.getStoredValue());
                }
            }
        }
        catch (EncryptionOperationNotPossibleException exception) {
            this.log.error(String.format("Encryption error on harvester settings password. Error is: %s. Check that encryptor.properties file match your database.", exception.getMessage()));
        }
    }
}

