/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.fao.geonet.utils.Log;

public class ObjectJSONUtils {
    public static String extractFieldFromJSONString(String jsonString, String field) {
        try {
            return ObjectJSONUtils.extractJSONObjectFromJSONString(jsonString).getString(field);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.domain", (String)("Error extracting field from JSON, error: " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    public static String extractFieldFromJSONString(String jsonString, String subObject, String field) {
        String[] levels = new String[]{subObject};
        return ObjectJSONUtils.extractFieldFromJSONString(jsonString, levels, field);
    }

    public static String extractFieldFromJSONString(String jsonString, String[] path, String field) {
        try {
            JSONObject current = ObjectJSONUtils.extractJSONObjectFromJSONString(jsonString);
            for (String level : path) {
                current = current.getJSONObject(level);
            }
            return current.getString(field);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.domain", (String)("Error extracting field from JSON, error: " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    public static JSONArray extractJSONArrayFromJSONString(String jsonString, String[] path) {
        try {
            JSONObject current = ObjectJSONUtils.extractJSONObjectFromJSONString(jsonString);
            for (String level : path) {
                if (current.get(level) instanceof JSONObject) {
                    current = current.getJSONObject(level);
                    continue;
                }
                if (!(current.get(level) instanceof JSONArray)) continue;
                return current.getJSONArray(level);
            }
            return null;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.domain", (String)("Error extracting array from JSON, error: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static JSONObject extractJSONObjectFromJSONString(String jsonString) throws JsonProcessingException {
        return JSONObject.fromObject((Object)jsonString);
    }

    public static List<String> extractListOfFieldFromJSONString(String jsonString, String subObject, String field) {
        String[] levels = new String[]{subObject};
        return ObjectJSONUtils.extractListOfFieldFromJSONString(jsonString, levels, field);
    }

    public static List<String> extractListOfFieldFromJSONString(String jsonString, String[] path, String field) {
        try {
            JSONArray array = ObjectJSONUtils.extractJSONArrayFromJSONString(jsonString, path);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject o = array.getJSONObject(i);
                result.add(o.getString(field));
            }
            return result;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.domain", (String)("Error extracting list of field from JSON, error: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static JSONObject convertObjectInJsonObject(Object object, String objectName) throws JsonProcessingException {
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        String jsonString = ow.writeValueAsString(object);
        JSON json = JSONSerializer.toJSON((Object)jsonString);
        JSONObject container = new JSONObject();
        container.put((Object)objectName, (Object)json);
        return container;
    }
}

