/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl.bing;

import org.geotools.tile.TileFactory;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.impl.WebMercatorTileService;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.tile.impl.bing.BingTileFactory;
import org.geotools.tile.impl.bing.BingTileIdentifier;
import org.geotools.tile.impl.bing.BingTileUtil;

public class BingService
extends WebMercatorTileService {
    private static final TileFactory tileFactory = new BingTileFactory();
    private static double[] SCALE_LIST = new double[]{2.9582935545E8, 1.4791467773E8, 7.395733886E7, 3.697866943E7, 1.848933472E7, 9244667.36, 4622333.68, 2311166.84, 1155583.42, 577791.71, 288895.85, 144447.93, 72223.96, 36111.98, 18055.99, 9028.0, 4514.0, 2257.0, 1128.5, 564.25, 282.12, 141.06, 70.53};

    public BingService(String name, String baseUrl) {
        super(name, baseUrl);
    }

    @Override
    public double[] getScaleList() {
        return SCALE_LIST;
    }

    @Override
    public TileFactory getTileFactory() {
        return tileFactory;
    }

    @Override
    public TileIdentifier identifyTileAtCoordinate(double lon, double lat, ZoomLevel zoomLevel) {
        int[] tileXY = BingTileUtil.lonLatToPixelXY(lon, lat, zoomLevel.getZoomLevel());
        int colX = (int)Math.floor(tileXY[0] / 256);
        int rowY = (int)Math.floor(tileXY[1] / 256);
        return new BingTileIdentifier(colX, rowY, zoomLevel, this.getName());
    }
}

