/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.tile.TileService;
import org.geotools.util.logging.Logging;

public abstract class WebMercatorTileService
extends TileService {
    private static final Logger LOGGER = Logging.getLogger(WebMercatorTileService.class);
    public static final double MIN_LONGITUDE = -180.0;
    public static final double MIN_LATITUDE = -85.05112878;
    public static final double MAX_LONGITUDE = 180.0;
    public static final double MAX_LATITUDE = 85.05112878;
    public static final CoordinateReferenceSystem WEB_MERCATOR_CRS;

    protected WebMercatorTileService(String name, String baseURL) {
        this(name, baseURL, HTTPClientFinder.createClient());
    }

    protected WebMercatorTileService(String name, String baseURL, HTTPClient client) {
        super(name, baseURL, client);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return new ReferencedEnvelope(-180.0, 180.0, -85.05112878, 85.05112878, DefaultGeographicCRS.WGS84);
    }

    @Override
    public CoordinateReferenceSystem getProjectedTileCrs() {
        return WEB_MERCATOR_CRS;
    }

    static {
        CoordinateReferenceSystem tmpCrs = null;
        try {
            tmpCrs = CRS.decode("EPSG:3857");
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, "Failed to create Web Mercator CRS EPSG:3857", e);
            throw new RuntimeException(e);
        }
        WEB_MERCATOR_CRS = tmpCrs;
    }
}

