/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile;

import org.geotools.tile.impl.ZoomLevel;

public abstract class TileIdentifier {
    private int x;
    private int y;
    private ZoomLevel zoomLevel;
    private String serviceName;

    public TileIdentifier(int x, int y, ZoomLevel zoomLevel, String serviceName) {
        this.setX(x);
        this.setY(y);
        this.setZomLevel(zoomLevel);
        this.setServiceName(serviceName);
    }

    private void setServiceName(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("Service name cannot be null");
        }
        this.serviceName = serviceName;
    }

    private void setX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("X must be >= 0 (" + x + ")");
        }
        this.x = x;
    }

    private void setY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("Y must be >= 0 (" + y + ")");
        }
        this.y = y;
    }

    private void setZomLevel(ZoomLevel zoomLevel) {
        if (zoomLevel == null) {
            throw new IllegalArgumentException("Zoom level cannot be null");
        }
        this.zoomLevel = zoomLevel;
    }

    public int getZ() {
        return this.zoomLevel.getZoomLevel();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public ZoomLevel getZoomLevel() {
        return this.zoomLevel;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public static final int arithmeticMod(int a, int b) {
        return a >= 0 ? a % b : a % b + b;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TileIdentifier)) {
            return false;
        }
        return this.getId().equals(((TileIdentifier)other).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    public abstract String getId();

    public abstract String getCode();

    public abstract TileIdentifier getRightNeighbour();

    public abstract TileIdentifier getLowerNeighbour();
}

