/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch;

import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.RDFChanges;

public class PatchHeader {
    private Map<String, Node> header;

    public PatchHeader(Map<String, Node> header) {
        this.header = header.entrySet().stream().collect(Collectors.toMap(e -> PatchHeader.lc((String)e.getKey()), e -> (Node)e.getValue()));
    }

    public Node getId() {
        return this.get("id");
    }

    public Node getPrevious() {
        Node n = this.get("prev");
        if (n == null) {
            n = this.get("previous");
        }
        return n;
    }

    public Node get(String field) {
        return this.header.get(PatchHeader.lc(field));
    }

    public void apply(RDFChanges changes) {
        Node idNode = this.getId();
        Node prevNode = this.getPrevious();
        if (idNode != null) {
            changes.header("id", idNode);
        }
        if (prevNode != null) {
            changes.header("prev", prevNode);
        }
        this.forEach((s, n) -> {
            switch (s) {
                case "id": 
                case "prev": 
                case "previous": {
                    return;
                }
            }
            changes.header((String)s, (Node)n);
        });
    }

    public void forEach(BiConsumer<String, Node> action) {
        this.header.forEach(action);
    }

    private static String lc(String str) {
        return str.toLowerCase(Locale.ROOT);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatchHeader other = (PatchHeader)obj;
        return !(this.header == null ? other.header != null : !this.header.equals(other.header));
    }

    public String toString() {
        return this.header.toString();
    }
}

