/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.system;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.dboe.storage.StorageRDF;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

public class StorageLib {
    private static final int DeleteBufferSize = 1000;

    public static void removeTriples(StorageRDF storage, Node s, Node p, Node o) {
        int idx;
        Triple[] buffer = new Triple[1000];
        do {
            Iterator iter = Iter.limit(storage.find(s, p, o), (long)1000L);
            for (idx = 0; idx < 1000 && iter.hasNext(); ++idx) {
                buffer[idx] = (Triple)iter.next();
            }
            for (int i = 0; i < idx; ++i) {
                storage.delete(buffer[i]);
                buffer[i] = null;
            }
        } while (idx >= 1000);
    }

    public static void removeQuads(StorageRDF storage, Node g, Node s, Node p, Node o) {
        int idx;
        Quad[] buffer = new Quad[1000];
        do {
            Iterator iter = Iter.limit(storage.find(g, s, p, o), (long)1000L);
            for (idx = 0; idx < 1000 && iter.hasNext(); ++idx) {
                buffer[idx] = (Quad)iter.next();
            }
            for (int i = 0; i < idx; ++i) {
                storage.delete(buffer[i]);
                buffer[i] = null;
            }
        } while (idx >= 1000);
    }
}

