/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.responses;

import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.domain.ISODate;
import org.fao.oaipmh.OaiPmh;
import org.fao.oaipmh.responses.AbstractResponse;
import org.jdom.Content;
import org.jdom.Element;

public class IdentifyResponse
extends AbstractResponse {
    private String reposName;
    private String baseURL;
    private ISODate earlDateStamp;
    private DeletedRecord deletedRecord;
    private Granularity granularity;
    private List<String> adminEmails = new ArrayList<String>();
    private List<String> compressions = new ArrayList<String>();
    private List<Element> descriptions = new ArrayList<Element>();

    public IdentifyResponse() {
    }

    public IdentifyResponse(Element response) {
        super(response);
        this.build(response);
    }

    public String getRepositoryName() {
        return this.reposName;
    }

    public void setRepositoryName(String name) {
        this.reposName = name;
    }

    public String getBaseUrl() {
        return this.baseURL;
    }

    public void setBaseUrl(String url) {
        this.baseURL = url;
    }

    public ISODate getEarliestDateStamp() {
        return this.earlDateStamp;
    }

    public void setEarliestDateStamp(ISODate dateStamp) {
        this.earlDateStamp = dateStamp;
    }

    public DeletedRecord getDeletedRecord() {
        return this.deletedRecord;
    }

    public void setDeletedRecord(DeletedRecord dr) {
        this.deletedRecord = dr;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public void setGranularity(Granularity g) {
        this.granularity = g;
    }

    public void clearAdminEmails() {
        this.adminEmails.clear();
    }

    public void addAdminEmail(String email) {
        this.adminEmails.add(email);
    }

    @Override
    public Element toXml() {
        Element root = new Element("Identify", OaiPmh.Namespaces.OAI_PMH);
        this.add(root, "repositoryName", this.reposName);
        this.add(root, "baseURL", this.baseURL);
        this.add(root, "protocolVersion", "2.0");
        for (String email : this.adminEmails) {
            this.add(root, "adminEmail", email);
        }
        this.add(root, "earliestDatestamp", this.earlDateStamp.getDateAndTime());
        this.add(root, "deletedRecord", this.deletedRecord.toString());
        this.add(root, "granularity", this.granularity.toString());
        for (String compression : this.compressions) {
            this.add(root, "compression", compression);
        }
        for (Element descr : this.descriptions) {
            root.addContent((Content)((Element)descr.clone()));
        }
        return root;
    }

    private void build(Element response) {
        Element ident = response.getChild("Identify", OaiPmh.Namespaces.OAI_PMH);
        this.reposName = ident.getChildText("repositoryName", OaiPmh.Namespaces.OAI_PMH);
        this.baseURL = ident.getChildText("baseURL", OaiPmh.Namespaces.OAI_PMH);
        String eds = ident.getChildText("earliestDatestamp", OaiPmh.Namespaces.OAI_PMH);
        this.earlDateStamp = new ISODate(eds);
        for (Object o : ident.getChildren("adminEmail", OaiPmh.Namespaces.OAI_PMH)) {
            Element email = (Element)o;
            this.adminEmails.add(email.getText());
        }
        String gran = ident.getChildText("granularity", OaiPmh.Namespaces.OAI_PMH);
        this.granularity = Granularity.parse(gran);
        String delRec = ident.getChildText("deletedRecord", OaiPmh.Namespaces.OAI_PMH);
        this.deletedRecord = DeletedRecord.parse(delRec);
        for (Object o : ident.getChildren("compression", OaiPmh.Namespaces.OAI_PMH)) {
            Element comp = (Element)o;
            this.compressions.add(comp.getText());
        }
        for (Object o : ident.getChildren("description", OaiPmh.Namespaces.OAI_PMH)) {
            this.descriptions.add((Element)o);
        }
    }

    public static enum DeletedRecord {
        NO("no"),
        PERSISTENT("persistent"),
        TRANSIENT("transient");

        private String type;

        private DeletedRecord(String type) {
            this.type = type;
        }

        public static DeletedRecord parse(String type) {
            if (type.equals(NO.toString())) {
                return NO;
            }
            if (type.equals(PERSISTENT.toString())) {
                return PERSISTENT;
            }
            if (type.equals(TRANSIENT.toString())) {
                return TRANSIENT;
            }
            throw new RuntimeException("Unknown deleted record type : " + type);
        }

        public String toString() {
            return this.type;
        }
    }

    public static enum Granularity {
        SHORT("YYYY-MM-DD"),
        LONG("YYYY-MM-DDThh:mm:ssZ");

        private String type;

        private Granularity(String type) {
            this.type = type;
        }

        public static Granularity parse(String type) {
            if (type.equals(SHORT.toString())) {
                return SHORT;
            }
            if (type.equals(LONG.toString())) {
                return LONG;
            }
            throw new RuntimeException("Unknown granularity type : " + type);
        }

        public String toString() {
            return this.type;
        }
    }
}

