/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizationSuccessHandler;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class DefaultReactiveOAuth2AuthorizedClientManager
implements ReactiveOAuth2AuthorizedClientManager {
    private static final ReactiveOAuth2AuthorizedClientProvider DEFAULT_AUTHORIZED_CLIENT_PROVIDER = ReactiveOAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().password().build();
    private static final Mono<ServerWebExchange> currentServerWebExchangeMono = Mono.subscriberContext().filter(c -> c.hasKey(ServerWebExchange.class)).map(c -> (ServerWebExchange)c.get(ServerWebExchange.class));
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private final ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
    private ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = DEFAULT_AUTHORIZED_CLIENT_PROVIDER;
    private Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> contextAttributesMapper = new DefaultContextAttributesMapper();
    private ReactiveOAuth2AuthorizationSuccessHandler authorizationSuccessHandler;
    private ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler;

    public DefaultReactiveOAuth2AuthorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientRepository = authorizedClientRepository;
        this.authorizationSuccessHandler = (authorizedClient, principal, attributes) -> authorizedClientRepository.saveAuthorizedClient(authorizedClient, principal, (ServerWebExchange)attributes.get(ServerWebExchange.class.getName()));
        this.authorizationFailureHandler = new RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler((clientRegistrationId, principal, attributes) -> authorizedClientRepository.removeAuthorizedClient(clientRegistrationId, principal, (ServerWebExchange)attributes.get(ServerWebExchange.class.getName())));
    }

    @Override
    public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizeRequest authorizeRequest) {
        Assert.notNull((Object)authorizeRequest, (String)"authorizeRequest cannot be null");
        String clientRegistrationId = authorizeRequest.getClientRegistrationId();
        Authentication principal = authorizeRequest.getPrincipal();
        return Mono.justOrEmpty(authorizeRequest.getAttribute(ServerWebExchange.class.getName())).switchIfEmpty(currentServerWebExchangeMono).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("serverWebExchange cannot be null"))).flatMap(serverWebExchange -> Mono.justOrEmpty((Object)authorizeRequest.getAuthorizedClient()).switchIfEmpty(Mono.defer(() -> this.loadAuthorizedClient(clientRegistrationId, principal, (ServerWebExchange)serverWebExchange))).flatMap(authorizedClient -> this.authorizationContext(authorizeRequest, (OAuth2AuthorizedClient)authorizedClient).flatMap(authorizationContext -> this.authorize((OAuth2AuthorizationContext)authorizationContext, principal, (ServerWebExchange)serverWebExchange)).defaultIfEmpty((Object)(authorizeRequest.getAuthorizedClient() != null ? authorizeRequest.getAuthorizedClient() : authorizedClient))).switchIfEmpty(Mono.defer(() -> this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("Could not find ClientRegistration with id '" + clientRegistrationId + "'"))).flatMap(clientRegistration -> this.authorizationContext(authorizeRequest, (ClientRegistration)clientRegistration)).flatMap(authorizationContext -> this.authorize((OAuth2AuthorizationContext)authorizationContext, principal, (ServerWebExchange)serverWebExchange)))));
    }

    private Mono<OAuth2AuthorizedClient> loadAuthorizedClient(String clientRegistrationId, Authentication principal, ServerWebExchange serverWebExchange) {
        return this.authorizedClientRepository.loadAuthorizedClient(clientRegistrationId, principal, serverWebExchange);
    }

    private Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizationContext authorizationContext, Authentication principal, ServerWebExchange serverWebExchange) {
        return this.authorizedClientProvider.authorize(authorizationContext).flatMap(authorizedClient -> this.authorizationSuccessHandler.onAuthorizationSuccess((OAuth2AuthorizedClient)authorizedClient, principal, this.createAttributes(serverWebExchange)).thenReturn(authorizedClient)).onErrorResume(OAuth2AuthorizationException.class, authorizationException -> this.authorizationFailureHandler.onAuthorizationFailure((OAuth2AuthorizationException)((Object)authorizationException), principal, this.createAttributes(serverWebExchange)).then(Mono.error((Throwable)authorizationException)));
    }

    private Map<String, Object> createAttributes(ServerWebExchange serverWebExchange) {
        return Collections.singletonMap(ServerWebExchange.class.getName(), serverWebExchange);
    }

    private Mono<OAuth2AuthorizationContext> authorizationContext(OAuth2AuthorizeRequest authorizeRequest, OAuth2AuthorizedClient authorizedClient) {
        return Mono.just((Object)authorizeRequest).flatMap(this.contextAttributesMapper).map(attrs -> OAuth2AuthorizationContext.withAuthorizedClient(authorizedClient).principal(authorizeRequest.getPrincipal()).attributes(attributes -> {
            if (!CollectionUtils.isEmpty((Map)attrs)) {
                attributes.putAll(attrs);
            }
        }).build());
    }

    private Mono<OAuth2AuthorizationContext> authorizationContext(OAuth2AuthorizeRequest authorizeRequest, ClientRegistration clientRegistration) {
        return Mono.just((Object)authorizeRequest).flatMap(this.contextAttributesMapper).map(attrs -> OAuth2AuthorizationContext.withClientRegistration(clientRegistration).principal(authorizeRequest.getPrincipal()).attributes(attributes -> {
            if (!CollectionUtils.isEmpty((Map)attrs)) {
                attributes.putAll(attrs);
            }
        }).build());
    }

    public void setAuthorizedClientProvider(ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider) {
        Assert.notNull((Object)authorizedClientProvider, (String)"authorizedClientProvider cannot be null");
        this.authorizedClientProvider = authorizedClientProvider;
    }

    public void setContextAttributesMapper(Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> contextAttributesMapper) {
        Assert.notNull(contextAttributesMapper, (String)"contextAttributesMapper cannot be null");
        this.contextAttributesMapper = contextAttributesMapper;
    }

    public void setAuthorizationSuccessHandler(ReactiveOAuth2AuthorizationSuccessHandler authorizationSuccessHandler) {
        Assert.notNull((Object)authorizationSuccessHandler, (String)"authorizationSuccessHandler cannot be null");
        this.authorizationSuccessHandler = authorizationSuccessHandler;
    }

    public void setAuthorizationFailureHandler(ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler) {
        Assert.notNull((Object)authorizationFailureHandler, (String)"authorizationFailureHandler cannot be null");
        this.authorizationFailureHandler = authorizationFailureHandler;
    }

    public static class DefaultContextAttributesMapper
    implements Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> {
        @Override
        public Mono<Map<String, Object>> apply(OAuth2AuthorizeRequest authorizeRequest) {
            ServerWebExchange serverWebExchange = (ServerWebExchange)authorizeRequest.getAttribute(ServerWebExchange.class.getName());
            return Mono.justOrEmpty((Object)serverWebExchange).switchIfEmpty(currentServerWebExchangeMono).flatMap(exchange -> {
                Map<String, String[]> contextAttributes = Collections.emptyMap();
                String scope = (String)exchange.getRequest().getQueryParams().getFirst((Object)"scope");
                if (StringUtils.hasText((String)scope)) {
                    contextAttributes = new HashMap();
                    contextAttributes.put(OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME, StringUtils.delimitedListToStringArray((String)scope, (String)" "));
                }
                return Mono.just(contextAttributes);
            }).defaultIfEmpty(Collections.emptyMap());
        }
    }
}

