/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import org.apache.camel.component.http4.HttpClientConfigurer;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;

public class ProxyHttpClientConfigurer
implements HttpClientConfigurer {
    private final String host;
    private final Integer port;
    private final String scheme;
    private final String username;
    private final String password;
    private final String domain;
    private final String ntHost;

    public ProxyHttpClientConfigurer(String host, Integer port, String scheme) {
        this(host, port, scheme, null, null, null, null);
    }

    public ProxyHttpClientConfigurer(String host, Integer port, String scheme, String username, String password, String domain, String ntHost) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
        this.username = username;
        this.password = password;
        this.domain = domain;
        this.ntHost = ntHost;
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        clientBuilder.setProxy(new HttpHost(this.host, this.port.intValue(), this.scheme));
        if (this.username != null && this.password != null) {
            Object defaultcreds = this.domain != null ? new NTCredentials(this.username, this.password, this.ntHost, this.domain) : new UsernamePasswordCredentials(this.username, this.password);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }
}

