/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockException;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.block.BlockMgrTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTracker
implements BlockMgr {
    public static Logger logger = LoggerFactory.getLogger(BlockTracker.class);
    public static boolean collectHistory = true;
    static final Long NoId = -9L;
    protected final MultiSet<Long> activeWriteBlocks = new HashMultiSet();
    protected final MultiSet<Long> activeReadBlocks = new HashMultiSet();
    protected final List<Pair<Action, Long>> actions = new ArrayList<Pair<Action, Long>>();
    protected final BlockMgr blockMgr;
    private int inRead = 0;
    private int inUpdate = 0;
    private final Logger log;
    private final String label;

    private void clearBlockTracking() {
        this.activeReadBlocks.clear();
        this.activeWriteBlocks.clear();
        this.actions.clear();
    }

    public void clearHistory() {
        this.actions.clear();
    }

    public void clearAll() {
        this.clearBlockTracking();
    }

    public static BlockMgr track(BlockMgr blkMgr) {
        return BlockTracker.track(blkMgr.getLabel(), blkMgr);
    }

    private static BlockMgr track(String label, BlockMgr blkMgr) {
        return new BlockTracker(label, blkMgr);
    }

    private BlockTracker(BlockMgr blockMgr) {
        this(LoggerFactory.getLogger(BlockMgrTracker.class), blockMgr.getLabel(), blockMgr);
    }

    private BlockTracker(String label, BlockMgr blockMgr) {
        this(logger, label, blockMgr);
    }

    private BlockTracker(Logger logger, String label, BlockMgr blockMgr) {
        this.blockMgr = blockMgr;
        this.log = logger;
        this.label = blockMgr.getLabel();
    }

    private void add(Action action, Long id) {
        if (collectHistory) {
            this.actions.add((Pair<Action, Long>)new Pair((Object)action, (Object)id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block allocate(int blockSize) {
        Block block;
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkUpdate(Action.Alloc);
            block = this.blockMgr.allocate(blockSize);
            Long id = block.getId();
            this.activeWriteBlocks.add((Object)id);
            this.add(Action.Alloc, id);
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block getRead(long id) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkRead(Action.GetRead);
            Long x = id;
            this.add(Action.GetRead, x);
            if (this.activeWriteBlocks.contains((Object)x)) {
                this.activeWriteBlocks.add((Object)x);
            } else {
                this.activeReadBlocks.add((Object)x);
            }
        }
        return this.blockMgr.getRead(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block getWrite(long id) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkUpdate(Action.GetWrite);
            Long x = id;
            this.add(Action.GetWrite, x);
            this.activeWriteBlocks.add((Object)x);
        }
        return this.blockMgr.getWrite(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block promote(Block block) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkUpdate(Action.Promote);
            Long id = block.getId();
            this.add(Action.Promote, id);
            if (!this.activeWriteBlocks.contains((Object)id) && !this.activeReadBlocks.contains((Object)id)) {
                this.error(Action.Promote, id + " is not an active block");
            }
            while (this.activeReadBlocks.contains((Object)id)) {
                this.activeReadBlocks.remove((Object)id);
            }
            if (!this.activeWriteBlocks.contains((Object)id)) {
                this.activeWriteBlocks.add((Object)id);
            }
        }
        return this.blockMgr.promote(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Block block) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            Long id = block.getId();
            this.add(Action.Release, id);
            if (this.activeWriteBlocks.contains((Object)id)) {
                this.activeWriteBlocks.remove((Object)id);
            } else {
                this.activeReadBlocks.remove((Object)block.getId());
            }
        }
        this.blockMgr.release(block);
    }

    public void write(Block block) {
        if (logger.isInfoEnabled() && block.getId() == 2L) {
            this.debugPoint();
        }
        this.writeTracker(block);
        this.blockMgr.write(block);
    }

    public synchronized void overwrite(Block block) {
        this.writeTracker(block);
        this.blockMgr.overwrite(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTracker(Block block) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkUpdate(Action.Write);
            Long id = block.getId();
            this.add(Action.Write, id);
            if (!this.activeWriteBlocks.contains((Object)id)) {
                this.error(Action.Write, id + " is not an active write block");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Block block) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkUpdate(Action.Free);
            Long id = block.getId();
            this.add(Action.Free, id);
            if (this.activeReadBlocks.contains((Object)id)) {
                this.warn(Action.Free, id + " is a read block");
            }
            if (!this.activeWriteBlocks.contains((Object)id)) {
                this.error(Action.Free, id + " is not a write block");
            }
            this.activeWriteBlocks.remove((Object)id);
            if (this.activeWriteBlocks.getCount((Object)id) != 0) {
                this.warn(Action.Free, id + " has " + this.activeWriteBlocks.getCount((Object)id) + " outstanding write registrations");
            }
        }
        this.blockMgr.free(block);
    }

    public void sync() {
        this.blockMgr.sync();
    }

    public void syncForce() {
        this.blockMgr.syncForce();
    }

    public void close() {
        this.blockMgr.close();
    }

    public boolean isEmpty() {
        return this.blockMgr.isEmpty();
    }

    public long allocLimit() {
        return this.blockMgr.allocLimit();
    }

    public void resetAlloc(long boundary) {
        this.blockMgr.resetAlloc(boundary);
    }

    public boolean valid(int id) {
        return this.blockMgr.valid(id);
    }

    public boolean isClosed() {
        return this.blockMgr.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beginRead() {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            if (this.inUpdate != 0) {
                this.error(Action.BeginRead, "beginRead when already in update");
            }
            ++this.inRead;
        }
        this.blockMgr.beginRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endRead() {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            if (this.inRead == 0) {
                this.error(Action.EndRead, "endRead but not in read");
            }
            if (this.inUpdate != 0) {
                this.error(Action.EndRead, "endRead when in update");
            }
            this.checkEmpty("Outstanding write blocks at end of read operations!", this.activeWriteBlocks);
            if (this.inRead == 0) {
                this.checkEmpty("Outstanding read blocks at end of read operations", this.activeReadBlocks);
                this.clearBlockTracking();
            }
            --this.inRead;
        }
        this.blockMgr.endRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginUpdate() {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            if (this.inRead > 0) {
                this.error(Action.BeginUpdate, "beginUpdate when already in read");
            }
            if (this.inUpdate > 0) {
                this.error(Action.BeginUpdate, "beginUpdate when already in update");
            }
            ++this.inUpdate;
            this.clearBlockTracking();
        }
        this.blockMgr.beginUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            if (this.inUpdate == 0) {
                this.error(Action.EndUpdate, "endUpdate but not in update");
            }
            if (this.inRead > 0) {
                this.error(Action.EndUpdate, "endUpdate when in read");
            }
            this.checkEmpty("Outstanding read blocks at end of update operations", this.activeReadBlocks);
            this.checkEmpty("Outstanding write blocks at end of update operations", this.activeWriteBlocks);
            --this.inUpdate;
            this.clearBlockTracking();
        }
        this.blockMgr.endUpdate();
    }

    private void checkUpdate(Action action) {
        if (this.inUpdate == 0) {
            this.error(action, "called outside update");
        }
    }

    private void checkRead(Action action) {
        if (this.inUpdate == 0 && this.inRead == 0) {
            this.error(action, "Called outside update and read");
        }
    }

    private void checkEmpty(String string, MultiSet<Long> blocks) {
        if (!blocks.isEmpty()) {
            this.error(string);
            for (Long id : blocks) {
                this.warn("    Block: " + id);
            }
            if (collectHistory) {
                this.history();
            }
            throw new DBOpEnvException();
        }
    }

    private String msg(String string) {
        if (this.label == null) {
            return string;
        }
        return this.label + ": " + string;
    }

    private void info(String string) {
        this.log.info(this.msg(string));
    }

    private void warn(String string) {
        this.log.warn(this.msg(string));
    }

    private void warn(Action action, String string) {
        this.warn(action + ": " + string);
    }

    private void error(String string) {
        this.log.error(this.msg(string));
    }

    private void error(Action action, String string) {
        this.error(action + ": " + string);
        this.history();
        throw new BlockException(this.msg(action + ": " + string));
    }

    private void debugPoint() {
    }

    private void history() {
        this.info("History");
        for (Pair<Action, Long> p : this.actions) {
            if (p.getRight() != NoId) {
                this.log.info(String.format("%s:     %-12s  %d", this.label, p.getLeft(), p.getRight()));
                continue;
            }
            this.log.info(String.format("%s:     %-12s", this.label, p.getLeft()));
        }
    }

    public String toString() {
        return "BlockMgrTracker" + (String)(this.label == null ? "" : ": " + this.label);
    }

    public String getLabel() {
        return this.label;
    }

    static enum Action {
        Alloc,
        Promote,
        GetRead,
        GetWrite,
        Write,
        Release,
        Free,
        BeginIter,
        EndIter,
        IterRead,
        BeginRead,
        EndRead,
        BeginUpdate,
        EndUpdate;

    }
}

