/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.FeatureImplUtils;
import org.geotools.feature.type.AttributeDescriptorImpl;

public class ComplexAttributeImpl
extends AttributeImpl
implements ComplexAttribute {
    public ComplexAttributeImpl(Collection<Property> properties, AttributeDescriptor descriptor, Identifier id) {
        super(ComplexAttributeImpl.cloneProperties(properties), descriptor, id);
    }

    public ComplexAttributeImpl(Collection<Property> properties, ComplexType type, Identifier id) {
        this(properties, (AttributeDescriptor)new AttributeDescriptorImpl((AttributeType)type, type.getName(), 1, 1, true, null), id);
    }

    public ComplexType getType() {
        return (ComplexType)super.getType();
    }

    @Override
    public Collection<? extends Property> getValue() {
        List cast = (List)super.getValue();
        return FeatureImplUtils.unmodifiable(cast);
    }

    public Collection<Property> getProperties() {
        Collection cast = (Collection)super.getValue();
        return FeatureImplUtils.unmodifiable(cast);
    }

    protected List<Property> properties() {
        return (List)super.getValue();
    }

    public Collection<Property> getProperties(Name name) {
        ArrayList<Property> matches = new ArrayList<Property>();
        for (Property property : this.properties()) {
            if (!property.getName().equals((Object)name)) continue;
            matches.add(property);
        }
        return matches;
    }

    public Optional<Property> findLast(Name name) {
        List<Property> properties = this.properties();
        for (int i = properties.size() - 1; i > -1; --i) {
            Property p = properties.get(i);
            if (!name.equals((Object)p.getName())) continue;
            return Optional.of(p);
        }
        return Optional.empty();
    }

    public Stream<Property> findAll(Predicate<? super Property> predicate) {
        return this.properties().stream().filter(predicate);
    }

    public Optional<Property> find(Predicate<? super Property> predicate) {
        return this.properties().stream().filter(predicate).findFirst();
    }

    public Collection<Property> getProperties(String name) {
        ArrayList<Property> matches = new ArrayList<Property>();
        for (Property property : this.properties()) {
            if (!property.getName().getLocalPart().equals(name)) continue;
            matches.add(property);
        }
        return matches;
    }

    public Property getProperty(Name name) {
        for (Property property : this.properties()) {
            if (!property.getName().equals((Object)name)) continue;
            return property;
        }
        return null;
    }

    public Property getProperty(String name) {
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().getLocalPart().equals(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public void setValue(Object newValue) throws IllegalArgumentException, IllegalStateException {
        Collection cast = (Collection)newValue;
        this.setValue(cast);
    }

    public void setValue(Collection<Property> newValue) {
        List<Property> props = ComplexAttributeImpl.cloneProperties(newValue);
        super.setValue(props);
    }

    public void addValue(Property value) {
        this.properties().add(value);
    }

    private static <T> List<T> cloneProperties(Collection<T> original) {
        if (original == null) {
            return null;
        }
        return new ArrayList<T>(original);
    }
}

