/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.MultiCurve;
import org.geotools.geometry.jts.MultiCurvedGeometry;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryTypeConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(GeometryTypeConverterFactory.class);
    static GeometryFactory gFac = new GeometryFactory();

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (Geometry.class.isAssignableFrom(source) && CurvedGeometry.class.isAssignableFrom(target)) {
            return new CurvedGeometryConverter();
        }
        if (Geometry.class.isAssignableFrom(source) && Geometry.class.isAssignableFrom(target)) {
            return new GeometryToGeometryConverter();
        }
        return null;
    }

    protected void copyUserProperties(Geometry sourceGeometry, Geometry destGeometry) {
        if (destGeometry != null) {
            HashMap<Class<CoordinateReferenceSystem>, Object> newUserData = new HashMap<Class<CoordinateReferenceSystem>, Object>();
            if (destGeometry.getUserData() instanceof Map) {
                newUserData.putAll((Map)destGeometry.getUserData());
            } else if (destGeometry.getUserData() instanceof CoordinateReferenceSystem) {
                newUserData.put(CoordinateReferenceSystem.class, destGeometry.getUserData());
            }
            if (sourceGeometry.getUserData() instanceof Map) {
                newUserData.putAll((Map)sourceGeometry.getUserData());
            } else if (sourceGeometry.getUserData() instanceof CoordinateReferenceSystem) {
                newUserData.put(CoordinateReferenceSystem.class, sourceGeometry.getUserData());
            }
            destGeometry.setUserData(newUserData);
        }
    }

    private class CurvedGeometryConverter
    implements Converter {
        private CurvedGeometryConverter() {
        }

        private <C extends GeometryCollection, G extends Geometry> List<G> getGeoms(C original) {
            ArrayList<Geometry> components = new ArrayList<Geometry>();
            for (int i = 0; i < original.getNumGeometries(); ++i) {
                components.add(original.getGeometryN(i));
            }
            return components;
        }

        private <G extends Geometry> Double getTolerance(List<G> components) {
            double tolerance = Double.MAX_VALUE;
            for (Geometry currentGeom : components) {
                if (!(currentGeom instanceof CurvedGeometry)) continue;
                tolerance = Math.min(tolerance, ((CurvedGeometry)currentGeom).getTolerance());
            }
            return tolerance;
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            LineString converted;
            LinearRing cr;
            CurvedGeometry<LineString> result = null;
            Geometry sourceGeometry = (Geometry)source;
            if (MultiCurvedGeometry.class.isAssignableFrom(target)) {
                GeometryFactory factory = ((Geometry)source).getFactory();
                if (MultiSurface.class.isAssignableFrom(target)) {
                    List<Object> components = null;
                    components = source instanceof Polygon ? Arrays.asList((Polygon)source) : this.getGeoms((MultiPolygon)source);
                    double tolerance = this.getTolerance(components);
                    result = new MultiSurface(components, factory, tolerance);
                } else {
                    MultiLineString multiLineString = (MultiLineString)Converters.convert((Object)source, MultiLineString.class);
                    if (multiLineString == null) {
                        return null;
                    }
                    List<LineString> components = this.getGeoms(multiLineString);
                    double tolerance = this.getTolerance(components);
                    result = new MultiCurve(components, factory, tolerance);
                }
            } else if (source instanceof CircularRing && CircularString.class.isAssignableFrom(target)) {
                cr = (CircularRing)source;
                result = new CircularString(cr.getControlPoints(), cr.getFactory(), cr.getTolerance());
            } else if (source instanceof CompoundRing && CompoundCurve.class.isAssignableFrom(target)) {
                cr = (CompoundRing)source;
                result = new CompoundCurve(cr.getComponents(), cr.getFactory(), cr.getTolerance());
            } else {
                converted = (LineString)Converters.convert((Object)source, LineString.class);
                if (converted.isEmpty()) {
                    ArrayList<LineString> components = new ArrayList<LineString>();
                    result = new CompoundRing(components, converted.getFactory(), Double.MAX_VALUE);
                } else {
                    result = converted instanceof LinearRing ? new CompoundRing(Arrays.asList(converted), ((LineString)source).getFactory(), Double.MAX_VALUE) : new CompoundCurve(Arrays.asList(converted), converted.getFactory(), Double.MAX_VALUE);
                }
            }
            if (result != null) {
                GeometryTypeConverterFactory.this.copyUserProperties(sourceGeometry, (Geometry)result);
            }
            converted = result;
            return (T)converted;
        }
    }

    private class GeometryToGeometryConverter
    implements Converter {
        private GeometryToGeometryConverter() {
        }

        public <T> List<T> convertAll(GeometryCollection gc, Class<T> target) throws Exception {
            ArrayList<T> result = new ArrayList<T>();
            for (int count = 0; count < gc.getNumGeometries(); ++count) {
                T geo = this.convert(gc.getGeometryN(count), target);
                if (geo == null) continue;
                result.add(geo);
            }
            return result;
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (target.isAssignableFrom(source.getClass())) {
                return (T)source;
            }
            if (source instanceof Geometry) {
                Geometry sourceGeometry = (Geometry)source;
                MultiPoint destGeometry = null;
                if (MultiPoint.class.isAssignableFrom(target)) {
                    Point[] points = sourceGeometry.isEmpty() ? new Point[]{} : (source instanceof Point ? new Point[]{(Point)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, Point.class).toArray(new Point[0]) : new Point[]{this.convert(source, Point.class)}));
                    destGeometry = gFac.createMultiPoint(points);
                } else if (MultiLineString.class.isAssignableFrom(target)) {
                    LineString[] lineStrings = sourceGeometry.isEmpty() ? new LineString[]{} : (source instanceof LineString ? new LineString[]{(LineString)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, LineString.class).toArray(new LineString[0]) : new LineString[]{this.convert(source, LineString.class)}));
                    destGeometry = gFac.createMultiLineString(lineStrings);
                } else if (MultiPolygon.class.isAssignableFrom(target)) {
                    Polygon[] polygons;
                    if (sourceGeometry.isEmpty()) {
                        polygons = new Polygon[]{};
                    } else if (source instanceof Polygon) {
                        Polygon polygon = (Polygon)source;
                        LinearRing exterior = polygon.getExteriorRing();
                        LinearRing[] interiors = new LinearRing[polygon.getNumInteriorRing()];
                        for (int i = 0; i < interiors.length; ++i) {
                            interiors[i] = polygon.getInteriorRingN(i);
                        }
                        polygons = new Polygon[]{gFac.createPolygon(exterior, interiors)};
                    } else {
                        polygons = source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, Polygon.class).toArray(new Polygon[0]) : new Polygon[]{this.convert(source, Polygon.class)};
                    }
                    destGeometry = gFac.createMultiPolygon(polygons);
                } else if (GeometryCollection.class.isAssignableFrom(target)) {
                    destGeometry = sourceGeometry.isEmpty() ? gFac.createGeometryCollection(new Geometry[0]) : gFac.createGeometryCollection(new Geometry[]{(Geometry)source});
                } else if (Point.class.isAssignableFrom(target)) {
                    if (sourceGeometry.isEmpty()) {
                        destGeometry = gFac.createPoint((Coordinate)null);
                    } else if (source instanceof MultiPoint && sourceGeometry.getNumGeometries() == 1) {
                        destGeometry = ((MultiPoint)source).getGeometryN(0).copy();
                    } else {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Converting Geometry " + source.toString() + " to Point. This could be unsafe");
                        }
                        destGeometry = ((Geometry)source).getCentroid();
                    }
                } else if (LineString.class.isAssignableFrom(target)) {
                    if (sourceGeometry.isEmpty()) {
                        destGeometry = gFac.createLineString(new Coordinate[0]);
                    } else if (source instanceof MultiLineString && sourceGeometry.getNumGeometries() == 1) {
                        destGeometry = ((MultiLineString)source).getGeometryN(0).copy();
                    } else {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Converting Geometry " + source.toString() + " to LineString. This could be unsafe");
                        }
                        destGeometry = gFac.createLineString(this.getLineStringCoordinates(((Geometry)source).getCoordinates()));
                    }
                } else if (Polygon.class.isAssignableFrom(target)) {
                    if (sourceGeometry.isEmpty()) {
                        destGeometry = gFac.createLineString(new Coordinate[0]);
                    } else if (source instanceof MultiPolygon && sourceGeometry.getNumGeometries() == 1) {
                        destGeometry = ((MultiPolygon)source).getGeometryN(0).copy();
                    } else {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Converting Geometry " + source.toString() + " to Polygon. This could be unsafe");
                        }
                        Coordinate[] coords = this.getPolygonCoordinates(((Geometry)source).getCoordinates());
                        destGeometry = gFac.createPolygon(gFac.createLinearRing(coords), new LinearRing[0]);
                    }
                }
                GeometryTypeConverterFactory.this.copyUserProperties(sourceGeometry, (Geometry)destGeometry);
                if (destGeometry != null) {
                    destGeometry.setSRID(sourceGeometry.getSRID());
                }
                return (T)destGeometry;
            }
            return null;
        }

        private <T> T[] arrayCopy(T[] original, int length) {
            Class<?> arrayType = original.getClass().getComponentType();
            Object[] copy = (Object[])Array.newInstance(arrayType, length);
            System.arraycopy(original, 0, copy, 0, original.length < length ? original.length : length);
            return copy;
        }

        private Coordinate[] growCoordinatesNum(Coordinate[] input, int numpoints) {
            if (input.length < numpoints) {
                Object[] newCoordinates = this.arrayCopy(input, numpoints);
                Arrays.fill(newCoordinates, input.length, numpoints, input[0]);
                input = newCoordinates;
            }
            return input;
        }

        private Coordinate[] getLineStringCoordinates(Coordinate ... coordinates) {
            coordinates = this.growCoordinatesNum(coordinates, 2);
            return coordinates;
        }

        private Coordinate[] getPolygonCoordinates(Coordinate ... coordinates) {
            if (!(coordinates = this.growCoordinatesNum(coordinates, 4))[coordinates.length - 1].equals((Object)coordinates[0])) {
                Coordinate[] newCoordinates = this.arrayCopy(coordinates, coordinates.length + 1);
                newCoordinates[newCoordinates.length - 1] = newCoordinates[0];
                coordinates = newCoordinates;
            }
            return coordinates;
        }
    }
}

