/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ByteCollection;
import bak.pcj.adapter.CollectionToByteCollectionAdapter;
import bak.pcj.adapter.SetToShortSetAdapter;
import bak.pcj.map.AbstractShortKeyByteMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyByteMap;
import bak.pcj.map.ShortKeyByteMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToShortKeyByteMapAdapter
extends AbstractShortKeyByteMap
implements ShortKeyByteMap {
    protected Map map;
    protected Byte lastValue;

    public MapToShortKeyByteMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToShortKeyByteMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(short key) {
        this.lastValue = (Byte)this.map.get(new Short(key));
        return this.lastValue != null;
    }

    public boolean containsValue(byte value) {
        return this.map.containsValue(new Byte(value));
    }

    public ShortKeyByteMapIterator entries() {
        return new ShortKeyByteMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToShortKeyByteMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public short getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getKey();
            }

            public byte getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public byte get(short key) {
        Byte value = (Byte)this.map.get(new Short(key));
        return value == null ? MapDefaults.defaultByte() : value;
    }

    public ShortSet keySet() {
        return new SetToShortSetAdapter(this.map.keySet());
    }

    public byte lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public byte put(short key, byte value) {
        Byte oldValue = this.map.put(new Short(key), new Byte(value));
        return oldValue == null ? MapDefaults.defaultByte() : oldValue;
    }

    public byte remove(short key) {
        Byte value = (Byte)this.map.remove(new Short(key));
        return value == null ? MapDefaults.defaultByte() : value;
    }

    public int size() {
        return this.map.size();
    }

    public ByteCollection values() {
        return new CollectionToByteCollectionAdapter(this.map.values());
    }

    public byte tget(short key) {
        Byte value = (Byte)this.map.get(new Short(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isShortKeyByteAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

