/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.IntCollection;
import bak.pcj.adapter.CollectionToIntCollectionAdapter;
import bak.pcj.adapter.SetToDoubleSetAdapter;
import bak.pcj.map.AbstractDoubleKeyIntMap;
import bak.pcj.map.DoubleKeyIntMap;
import bak.pcj.map.DoubleKeyIntMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToDoubleKeyIntMapAdapter
extends AbstractDoubleKeyIntMap
implements DoubleKeyIntMap {
    protected Map map;
    protected Integer lastValue;

    public MapToDoubleKeyIntMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToDoubleKeyIntMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(double key) {
        this.lastValue = (Integer)this.map.get(new Double(key));
        return this.lastValue != null;
    }

    public boolean containsValue(int value) {
        return this.map.containsValue(new Integer(value));
    }

    public DoubleKeyIntMapIterator entries() {
        return new DoubleKeyIntMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToDoubleKeyIntMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public double getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Double)this.lastEntry.getKey();
            }

            public int getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Integer)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public int get(double key) {
        Integer value = (Integer)this.map.get(new Double(key));
        return value == null ? MapDefaults.defaultInt() : value;
    }

    public DoubleSet keySet() {
        return new SetToDoubleSetAdapter(this.map.keySet());
    }

    public int lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public int put(double key, int value) {
        Integer oldValue = this.map.put(new Double(key), new Integer(value));
        return oldValue == null ? MapDefaults.defaultInt() : oldValue;
    }

    public int remove(double key) {
        Integer value = (Integer)this.map.remove(new Double(key));
        return value == null ? MapDefaults.defaultInt() : value;
    }

    public int size() {
        return this.map.size();
    }

    public IntCollection values() {
        return new CollectionToIntCollectionAdapter(this.map.values());
    }

    public int tget(double key) {
        Integer value = (Integer)this.map.get(new Double(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isDoubleKeyIntAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

