/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.ByteCollection;
import bak.pcj.adapter.ByteIteratorToIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class ByteCollectionToCollectionAdapter
extends AbstractCollection {
    protected ByteCollection collection;

    public ByteCollectionToCollectionAdapter(ByteCollection collection) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
    }

    public boolean add(Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        return this.collection.add((Byte)o);
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(Object o) {
        try {
            return this.collection.contains((Byte)o);
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public Iterator iterator() {
        return new ByteIteratorToIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(Object o) {
        try {
            return this.collection.remove((Byte)o);
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.retainAll(c);
    }

    public int size() {
        return this.collection.size();
    }

    public int hashCode() {
        return this.collection.hashCode();
    }
}

