/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.misc;

public abstract class UnitUtilities {
    private static final String[] COMPUTER_UNITS = new String[]{"", "K", "M", "G", "T", "P", "E"};

    public static String toComputerSize(double value) {
        int curUnit = 0;
        while (value >= 10000.0) {
            value /= 1024.0;
            ++curUnit;
        }
        if (curUnit > COMPUTER_UNITS.length) {
            throw new RuntimeException("Cannot convert (unit=2^3*" + curUnit + ")");
        }
        if (value < 10.0) {
            return String.format("%.2f%s", value, COMPUTER_UNITS[curUnit]);
        }
        if (value + 0.05 < 100.0) {
            return String.format("%.1f%s", value, COMPUTER_UNITS[curUnit]);
        }
        return String.format("%d%s", Math.round(value), COMPUTER_UNITS[curUnit]);
    }

    public static String toElapsedTime(long millis) {
        double secs = (double)millis / 1000.0;
        if (secs < 10.0) {
            return String.format("%dms", millis);
        }
        if (secs < 59.995) {
            return String.format("%.2fs", secs);
        }
        if (secs < 3599.5) {
            return String.format("%dm%02ds", (int)Math.floor((secs + 0.005) / 60.0), Math.round(secs) % 60L);
        }
        if (secs < 86399.5) {
            return String.format("%dh%02dm%02ds", (int)Math.floor((secs + 0.5) / 3600.0), (int)Math.floor((secs + 0.5) / 60.0) % 60, Math.round(secs) % 60L);
        }
        return String.format("%dd%02dh%02dm%02ds", (int)Math.floor((secs + 0.5) / 3600.0 / 24.0), (int)Math.floor((secs + 0.5) / 3600.0) % 24, (int)Math.floor((secs + 0.5) / 60.0) % 60, Math.round(secs) % 60L);
    }

    public static String toElapsedNanoTime(long nanos) {
        if (nanos < 10000L) {
            return String.format("%dns", nanos);
        }
        if (nanos < 9999500L) {
            return String.format("%dus", (nanos + 500L) / 1000L);
        }
        return UnitUtilities.toElapsedTime((nanos + 500000L) / 1000000L);
    }
}

