/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.concurrent;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderedResultsExecutor<RESULT> {
    public static Log LOGGER = LogFactory.getLog(OrderedResultsExecutor.class);
    private final String name;
    private final Thread[] threads;
    private AtomicLong nextSequenceNumber = new AtomicLong(0L);
    private final Queue<InternalTask<RESULT>> queue;
    private final SortedSet<InternalTask<RESULT>> output = Collections.synchronizedSortedSet(new TreeSet());
    private long nextOutput = 1L;
    private final Object nextOutputLock = new Object();

    public OrderedResultsExecutor(int nbThreads, String name) {
        this.name = name;
        this.threads = new Thread[nbThreads];
        this.queue = new LinkedList<InternalTask<RESULT>>();
    }

    public void start() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] != null) continue;
            Thread thread = this.threads[i] = new Thread((Runnable)new Runner(), this.name + i);
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Queue<InternalTask<RESULT>> queue = this.queue;
        synchronized (queue) {
            for (int i = 0; i < this.threads.length; ++i) {
                this.queue.add(new InternalTask(null, null, 0L));
            }
            this.queue.notifyAll();
        }
        for (int i = 0; i < this.threads.length; ++i) {
            Thread thread = this.threads[i];
            while (true) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.threads[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Task<RESULT> command, ResultCollector<RESULT> resultCollector) {
        Queue<InternalTask<RESULT>> queue = this.queue;
        synchronized (queue) {
            this.queue.add(new InternalTask<RESULT>(command, resultCollector, this.nextSequenceNumber.incrementAndGet()));
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOutput(InternalTask<RESULT> task) {
        this.output.add(task);
        while (true) {
            InternalTask<RESULT> first;
            ResultCollector resultCollector = this.nextOutputLock;
            synchronized (resultCollector) {
                if (this.output.isEmpty()) {
                    return;
                }
                first = this.output.first();
                if (first.sequenceNumber != this.nextOutput) {
                    return;
                }
            }
            resultCollector = first.resultCollector;
            synchronized (resultCollector) {
                Object object = this.nextOutputLock;
                synchronized (object) {
                    if (first.sequenceNumber != this.nextOutput) {
                        continue;
                    }
                    ++this.nextOutput;
                    this.output.remove(first);
                }
                first.resultCollector.handle(first.result);
            }
        }
    }

    public static interface ResultCollector<RESULT> {
        public void handle(RESULT var1);
    }

    public static interface Task<RESULT> {
        public RESULT process();
    }

    private static class InternalTask<RESULT>
    implements Comparable<InternalTask<RESULT>> {
        private final Task<RESULT> task;
        private final ResultCollector<RESULT> resultCollector;
        private final long sequenceNumber;
        private ExecutionState state;
        private RESULT result = null;
        private Throwable error;

        public InternalTask(Task<RESULT> task, ResultCollector<RESULT> resultCollector, long sequenceNumber) {
            this.task = task;
            this.resultCollector = resultCollector;
            this.sequenceNumber = sequenceNumber;
            this.state = ExecutionState.PENDING;
        }

        public void setResult(RESULT result) {
            if (this.result != null) {
                throw new RuntimeException("Synchronization bug");
            }
            this.result = result;
        }

        @Override
        public int compareTo(InternalTask<RESULT> o) {
            return this.sequenceNumber < o.sequenceNumber ? -1 : (this.sequenceNumber == o.sequenceNumber ? 0 : 1);
        }

        public synchronized void setState(ExecutionState state) {
            this.state = state;
        }

        public synchronized void setError(Throwable error) {
            this.error = error;
        }
    }

    private static enum ExecutionState {
        PENDING,
        RUNNING,
        DONE,
        ERROR;

    }

    public class Runner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Runner [" + OrderedResultsExecutor.this.name + "] started"));
            }
            while (true) {
                InternalTask cur;
                Queue queue = OrderedResultsExecutor.this.queue;
                synchronized (queue) {
                    while ((cur = OrderedResultsExecutor.this.queue.poll()) == null) {
                        try {
                            OrderedResultsExecutor.this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (cur.task == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Runner [" + OrderedResultsExecutor.this.name + "] stopped"));
                    }
                    return;
                }
                cur.setState(ExecutionState.RUNNING);
                try {
                    Object process = cur.task.process();
                    cur.setResult(process);
                    OrderedResultsExecutor.this.addOutput(cur);
                    continue;
                }
                catch (Throwable t) {
                    cur.setState(ExecutionState.ERROR);
                    cur.setError(t);
                    continue;
                }
                finally {
                    cur.setState(ExecutionState.DONE);
                    continue;
                }
                break;
            }
        }
    }
}

